var orgs;
var number_of_orgs;
var current_org=-1;

function get_licence_state() {
	
	$("#licenceOutput").append("<p>Fetching organisations...</p>");
	get_orgs();
	return;
	
}

function get_next_licence(data) {
	if ( current_org == -1 ){
		//First one to fetch
		$("#licenceOutput").append('<p id="licenceOutputCounter">Getting organisation ' + 1 + '/' + number_of_orgs +  ' (' + orgs[0].name + ')....</p>');
		current_org++;
		get_org_licences(orgs[current_org].id);
	}
	else {
		//We should be in a success clause, so parse data
		lic = data;
		if (typeof data == 'undefined') {
			//This shouldn't happen now
			orgs[current_org].licStatus = "ERROR";
			orgs[current_org].licExpirationDate = "ERROR";
			orgs[current_org].licLicensedDeviceCounts = "ERROR";
		}
		else {
			orgs[current_org].licStatus = lic['status'];
			orgs[current_org].licExpirationDate = Date.parse(lic['expirationDate']);
			orgs[current_org].licLicensedDeviceCounts = lic['licensedDeviceCounts'];			
		}
		
		if (current_org < number_of_orgs-1) {
			//More stuff to get....
			current_org++;
			$("#licenceOutputCounter").text('Getting organisation ' + parseInt(parseInt(current_org)+1) + '/' + number_of_orgs +  ' (' + orgs[current_org].name + ')....');
			get_org_licences(orgs[current_org].id);
		}
		else {
			//All done - print output...
			print_licence_output();
		}
	}
}

function print_licence_output() {
	$("#licenceOutput").append('<p>Sorting and generating output...</p>');
	sorted = orgs.sort(function(a, b) { return a.licExpirationDate - b.licExpirationDate; });
	$("#licenceOutput").html('<table id="licenceOutputTable">		<tr><td><b>Organisation</b></td><td><b>Status</b></td><td><b>Expiration Date</b></td><td><b>Devices</b></td></tr></table>');
	$.each(sorted, function(data) {
		d = new Date(sorted[data].licExpirationDate);
		n = d.toDateString();
		$("#licenceOutputTable").append('<tr><td>' + sorted[data].name + '</td><td>' + sorted[data].licStatus + '</td><td>' + n + '</td><td>'+ dump_licenced_devices(sorted[data].licLicensedDeviceCounts) + '</td></tr>');		
	});
}

function dump_licenced_devices(data) {
	var i = 0;
	var list = '';
	if (data != 'ERROR'){
		for (type in data) {
			if ( i != 0 ) {
				list = list + '<br/>';
			}
			list = list + type + ' --> ' + data[type];
			i++;
		}
	}
	else {
		list = 'ERROR';
	}
	return list;
}

function get_orgs_success(data) {
	orgs = data;
	number_of_orgs = orgs.length;
	$("#licenceOutput").append('<p>Got ' + number_of_orgs + ' organisations.  Fetching details....</p>');
	get_next_licence(0);
}

function get_orgs() {
	var key = $('#api-key').val();
	//Check if the user has entered anything
	//if(key == ''){
	//	key = 'rokey';
	//}
	$.ajax({
		dataType: "json",
		url: "licences.php?action=get_orgs&key=" + key,
		success: function(data) {get_orgs_success(data);} 
	});
}

function get_org_licences(orgid) {
	var key = $('#api-key').val();
	//Check if the user has entered anything
	//if(key == ''){
	//	key = 'rokey';
	//}
	$.ajax({
		dataType: "json",
		url: "licences.php?action=get_org_licences&orgid=" + orgid + "&key=" + key,
		success: function(data) { get_next_licence(data); },
		error: function (jqXHR, textStatus, errorThrown ) {
			console.log("Status: " + textStatus  + ", Error: " + errorThrown);
			orgs[current_org].licStatus = "ERROR";
			orgs[current_org].licExpirationDate = "ERROR";
			orgs[current_org].licLicensedDeviceCounts = "ERROR";
			if (current_org < number_of_orgs-1) {
				//More stuff to get....
				current_org++;
				$("#licenceOutputCounter").text('Getting organisation ' + parseInt(parseInt(current_org)+1) + '/' + number_of_orgs +  ' (' + orgs[current_org].name + ')....');
				get_org_licences(orgs[current_org].id);
			}
			else {
				//All done - print output...
				print_licence_output();
			}
		}
	});
}
