<?php
include ('include.php');

$page_name = "Meraki Administrators";
$page_header = preg_replace ( '/PAGE_NAME/', $page_name, $page_header );

if ( !isset ( $_GET['action'] ) || $_GET['action'] == "" ) {
	echo ( $page_header );
	new_request();
	echo ( $page_footer );
}
else {
	parse_request();
}

	function new_request() { 
		if ( !isset ( $_GET['page'] ) || $_GET['page'] == "" ) { ?>
		
			<p>Please select a function:</p>
			<ul>
				<li><a href="accounts.php?page=admins_by_org">List Administrators by Organisation</a></li>
				<li><a href="accounts.php?page=orgs_by_admin">List Organisations by Administrator</a></li>
				<li><a href="accounts.php?page=remove_admin">Remove an Administrator</a></li>
				<li><a href="accounts.php?page=add_admin">Add an Administrator</a></li>
			</ul>
		<?php }
		else {
			switch ($_GET['page']) {
				case "admins_by_org":
					page_admins_by_org();
					break;
				case "orgs_by_admin":
					page_orgs_by_admin();
					break;
				case "remove_admin":
					page_remove_admin();
					break;
				case "add_admin":
					page_add_admin();
					break;
				default:
					break;
			}
		}
		
		return;
	}

	
function page_admins_by_org() {	?>
		<div class="admins_by_org" id="admins_by_org">
			<h2>List of Administrators by Organisation</h2>
			<div id="adminsOutput"></div>
		</div>
		
		<script>
			get_admins_by_org();
		</script>

<?php }

function page_orgs_by_admin() {	?>
		<div class="orgs_by_admin" id="orgs_by_admin">
			<h2>List of Organisations by Administrator</h2>
			<div id="adminsOutput"></div>
		</div>
		
		<script>
			get_orgs_by_admin();
		</script>

<?php }

function page_remove_admin() {	?>
		<div class="orgs_by_admin" id="orgs_by_admin">
			<h2>Delete Administrator</h2>
			
			<div class="key">
				<label for="api-key">Your API Key: </label>
				<input type="password" name="api-key" id="api-key" length="40" />
				<input type="button" name="next1" id="next1" value="Next" onclick="get_admins_remove()">
			</div>
			
			<div class="adminsOutput" id="adminsOutput">
				<!--Dropdown list of Admins -->
				<!--Next -->
			</div>
			
			<div class="orgsOutput" id="orgsOutput">
				<!-- Checkboxes for orgs -->
				<!-- Remove -->
			</div>
			
			
		</div>
		
		<script>
			
		</script>

<?php }

function page_add_admin() {	?>
		


		<div class="orgs_by_admin" id="orgs_by_admin">
			<h2>Add Administrator</h2>
			<div class="meraki_container">
				<div class="meraki_row meraki_key">
					<div class="meraki_left meraki_key">
							<label for="api-key">Your API Key: </label>
					</div>
					<div class="meraki_right meraki_key">
						<input type="password" name="api-key" id="api-key" length="40" />
					</div>
				</div>
				<div class="meraki_row">
					<div class="meraki_left">
						<label for="fullname">Full name: </label>
					</div>
					<div class="meraki_right">
						<input type="text" name="fullname" id="fullname" length="40" />
					</div>
				</div>
				<div class="meraki_row">
					<div class="meraki_left">
						<label for="fullname">Email Address: </label>
					</div>
					<div class="meraki_right">
						<input type="text" name="email" id="email" length="40" />
					</div>
				</div>
				<div class="meraki_row">
					<div class="meraki_left">
						<label for="fullname">Access Level: </label>
					</div>
					<div class="meraki_right">
						<select name="access"id="access">
							<option value="full">Full</option>
							<option value="full">Read-Only</option>
						</select>
					</div>
				</div>
			</div>
			
			<input type="button" name="next1" id="next1" value="Next" onclick="get_orgs_add_admin()">
			
			<div class="orgsOutput" id="orgsOutput">
				<!-- Checkboxes for orgs -->
				<!-- Add -->
			</div>
			
		</div>
			
		<script>
			
		</script>

<?php }


?>