<?php
include ('include.php');

$page_name = "Meraki Administrators";
$page_header = preg_replace ( '/PAGE_NAME/', $page_name, $page_header );

if ( !isset ( $_POST['action'] ) || $_POST['action'] == "" ) {
	echo ( $page_header );
	new_request();
	echo ( $page_footer );
}
else {
	parse_request();
}

	function new_request() { 
		if ( !isset ( $_GET['page'] ) || $_GET['page'] == "" ) { ?>
		
			<p>Please select a function:</p>
			<ul>
				<li><a href="accounts.php?page=admins_by_org">List Administrators by Organisation</a></li>
				<li><a href="accounts.php?page=orgs_by_admin">List Organisations by Administrator</a></li>
				<li><a href="accounts.php?page=remove_admin">Remove an Administrator</a></li>
				<li><a href="accounts.php?page=add_admin">Add an Administrator</a></li>
			</ul>
		<?php }
		else {
			switch ($_GET['page']) {
				case "admins_by_org":
					page_admins_by_org();
					break;
				case "orgs_by_admin":
					page_orgs_by_admin();
					break;
				case "remove_admin":
					page_remove_admin();
					break;
				case "add_admin":
					page_add_admin();
					break;
				default:
					break;
			}
		}
		
		return;
	}

	
function page_admins_by_org() {	?>
		<div class="meraki_admins_by_org" id="meraki_admins_by_org">
			<h2>List of Administrators by Organisation</h2>

			<div id="meraki_status"><pre>Current status: Awaiting user input</pre></div>

			<div class="meraki_container meraki_form">
				<?php ro_key_fields(); ?>
				<div class="meraki_row">
					<div class="meraki_left">
						<input type="button" class="meraki_button" name="meraki_go" id="meraki_go" value="Fetch Administrators" onclick="get_admins_by_org();">
					</div>
				</div>
			</div>
			
			<div id="meraki_admins_output"></div>
		</div>
		<script>
			var page = "admins_by_org";
		</script>

<?php }

function page_orgs_by_admin() {	?>
		<div class="meraki_orgs_by_admin" id="meraki_orgs_by_admin">
			<h2>List of Organisations by Administrator</h2>

			<div id="meraki_status"><pre>Current status: Awaiting user input</pre></div>

			<div class="meraki_container meraki_form">
				<?php ro_key_fields(); ?>
				<div class="meraki_row">
					<div class="meraki_left">
						<input type="button" class="meraki_button" name="meraki_go" id="meraki_go" value="Fetch Administrators" onclick="get_admins_by_org();">
					</div>
				</div>
			</div>
			
			<div id="meraki_admins_output"></div>
		</div>
		<script>
			var page = "orgs_by_admin";
		</script>
<?php }

function page_remove_admin() {	?>
		<div class="orgs_by_admin" id="orgs_by_admin">
			<h2>Delete Administrator</h2>
			
			<div class="key">
				<label for="api-key">Your API Key: </label>
				<input type="password" name="api-key" id="api-key" length="40" />
				<input type="button" name="next1" id="next1" value="Next" onclick="get_admins_remove()">
			</div>
			
			<div class="adminsOutput" id="adminsOutput">
				<!--Dropdown list of Admins -->
				<!--Next -->
			</div>
			
			<div class="orgsOutput" id="orgsOutput">
				<!-- Checkboxes for orgs -->
				<!-- Remove -->
			</div>
			
			
		</div>
		
		<script>
			
		</script>

<?php }

function page_add_admin() {	?>
		


		<div class="orgs_by_admin" id="orgs_by_admin">
			<h2>Add Administrator</h2>
			<div id="meraki_status"><pre>Current status: Awaiting user input</pre></div>
			<div class="meraki_container meraki_form">
			
				<?php ro_key_fields(); ?> <!--TODO:  needs to be RW ONLY-->
				
				<div class="meraki_row">
					<div class="meraki_left">
						<label for="meraki_full_name">Full name: </label>
					</div>
					<div class="meraki_right">
						<input type="text" name="meraki_full_name" id="meraki_full_name" length="40" />
					</div>
				</div>
				<div class="meraki_row">
					<div class="meraki_left">
						<label for="meraki_email">Email Address: </label>
					</div>
					<div class="meraki_right">
						<input type="text" name="meraki_email" id="meraki_email" length="40" />
					</div>
				</div>
				<div class="meraki_row">
					<div class="meraki_left">
						<label for="meraki_access">Access Level: </label>
					</div>
					<div class="meraki_right">
						<select name="meraki_access" id="meraki_access">
							<option value="full">Full</option>
							<option value="full">Read-Only</option>
						</select>
					</div>
				</div>
				<input type="button" class="meraki_button" name="meraki_next1" id="meraki_next1" value="Next" onclick="get_admins_by_org();">
			</div>
			

			<div class="meraki_org_checkboxes meraki_container meraki_form2" id="meraki_orgsOutput">
				<!-- Checkboxes for orgs -->
				<!-- Add -->
			</div>
			
		</div>
			
		<script>
			var page = "add_admin";
		</script>

<?php }


?>