var orgs;
var number_of_orgs;
var orgs_completed=0;
var current_org=-1;
var key="";

$( document ).ready(function() {
	$("#meraki_ro_key").change(function(event) {
		var checkbox = event.target;
		if (checkbox.checked) {
			$(".meraki_key").hide();
		} else {
			$(".meraki_key").css('display', 'table-row');
		}
	});
});


//ADMIN FUNCTIONS

function get_admins_by_org() {
    status_update("Fetching organisations...");
	$(".meraki_form").hide();
	set_key();
    get_organisations(on_get_organisations_success_admins, on_get_organisations_error);
}


function on_get_organisations_success_admins(data) {
	orgs = data;
	number_of_orgs = orgs.length;
	status_update("Found " + number_of_orgs + " organisations - fetching admins...");
    $.each(data, function(org) {

        $.ajax({
            dataType: "json",
            url: "api.php",
			method: "post",
			data: {
				action: "get_org_admins",
				orgid: 	data[org].id,
				key: 	key
			},
            success: function (r) {on_get_admin_sucess(r, org);},
            error: function (x, s, e) {on_get_admin_error(e, org);}
        });
	});
}

function on_get_admin_sucess(administrator, org_index) {
    orgs[org_index].administrator = administrator;
	orgs_completed++;
    if(check_orgs_complete()) {
        print_admins_output();
    }
}

function on_get_admin_error(error, org_index) {
    orgs[org_index].administrator = [];
	orgs[org_index].administrator[0] = "ERROR";
	orgs_completed++;
    if(check_orgs_complete()) {
        print_admins_output();
    }
}

function print_admins_output() {
	if ( page == "orgs_by_admin" ){
		print_admins_output_by_admin();
	}
	else if ( page == "admins_by_org" ) {
		print_admins_output_by_org();
	}
	else if ( page == "add_admin" ) {
		print_orgs_to_add_admin();
	}
	else if ( page == "remove_admin" ) {
	}
	else {
		status_update("Errrrrr - this shouldn't ever be reached - something went very wrong!");
	}
}

function print_admins_output_by_org() {
	status_update('Sorting and generating output...');
	sorted = orgs.sort(function(a, b) { return a.name - b.name; });
	$("#meraki_admins_output").html('\
		<table class="meraki_output_table" id="meraki_admins_output_table">\
			<tr>\
				<td class="meraki_output_header_group"><b>Organisation</b></td>\
				<td class="meraki_output_header"><b>Name</b></td>\
				<td class="meraki_output_header"><b>Email Address</b></td>\
				<td class="meraki_output_header"><b>Access Level</b></td>\
			</tr>\
		</table>\
	');
	$.each(sorted, function(data) {
		if ( sorted[data].administrator[0] != "ERROR" ) {
			number_of_admins = sorted[data].administrator.length;
			$("#meraki_admins_output_table").append('\
				<tr>\
					<td rowspan="'+number_of_admins+'" class="meraki_output_group">' + sorted[data].name + '</td>\
					<td>' + sorted[data].administrator[0].name + '</td>\
					<td>' + sorted[data].administrator[0].email + '</td>\
					<td>' + sorted[data].administrator[0].orgAccess + '</td>\
				</tr>\
			');
			for (i=1; i<number_of_admins; i++) {
				$("#meraki_admins_output_table").append('\
					<tr>\
						<td>' + sorted[data].administrator[i].name + '</td>\
						<td>' + sorted[data].administrator[i].email + '</td>\
						<td>' + sorted[data].administrator[i].orgAccess + '</td>\
					</tr>\
				');
			}
		}
		else {
			$("#meraki_admins_output_table").append('\
				<tr>\
					<td class="meraki_output_group">' + sorted[data].name + '</td>\
					<td>ERROR</td>\
					<td>ERROR</td>\
					<td>ERROR</td>\
				</tr>\
			');
		}
	});
	status_update("Done...");
}

function print_admins_output_by_admin() {
	status_update('Sorting and generating output...');
	
	admins = group_orgs_by_admin();
	
	sorted = admins; //.sort(function(a, b) { return a.name - b.name; });
	$("#meraki_admins_output").html('\
		<table class="meraki_output_table" id="meraki_admins_output_table">\
			<tr>\
				<td class="meraki_output_header_group"><b>Email Address</b></td>\
				<td class="meraki_output_header_group"><b>Name</b></td>\
				<td class="meraki_output_header"><b>Organisation</b></td>\
				<td class="meraki_output_header"><b>Access Level</b></td>\
			</tr>\
		</table>\
	');
	$.each(sorted, function(j) {
		number_of_admins = sorted[j].length;
		$("#meraki_admins_output_table").append('\
			<tr>\
				<td rowspan="'+number_of_admins+'" class="meraki_output_group">' + j + '</td>\
				<td rowspan="'+number_of_admins+'" class="meraki_output_group">' + sorted[j].name + '</td>\
				<td>' + sorted[j][0].name + '</td>\
				<td>' + sorted[j][0].orgAccess + '</td>\
			</tr>\
		');
		for (i=1; i<number_of_admins; i++) {
			$("#meraki_admins_output_table").append('\
				<tr>\
					<td>' + sorted[j][i].name + '</td>\
					<td>' + sorted[j][i].orgAccess + '</td>\
				</tr>\
			');
		}
	});
	status_update("Done...");
}

function print_orgs_to_add_admin() {
	status_update('Sorting and generating output...');
	
	admins = group_orgs_by_admin();
	
	//check if admin exists - if not we can skip the per org checks
	var admin_to_add = $('#meraki_email').val();
	var admin_exists;
	if ( ! (admins[admin_to_add] ) ){
		admin_exists=false;
	}
	else {
		admin_exists = true;
	}
	
	$('#meraki_orgsOutput').append('\
		<p><div class="meraki_row">Please select the organisations to add this user to:</p></div>\
	');
	
	$.each (orgs, function (k) {
		$('#meraki_orgsOutput').append('<div class="meraki_row" id="meraki_orgs_'+k+'"></div>');
		$('#meraki_orgs_'+k).append('\
			<div class="meraki_left">\
				<label for="meraki_org_'+orgs[k].id+'">\
					'+orgs[k].name+'\
				</label>\
			</div>\
		');
		$('#meraki_orgs_'+k).append('\
			<div class="meraki_middle">\
				<input type="checkbox" name="org_checkboxes[]" value="'+orgs[k].id+'" id="meraki_org_'+orgs[k].id+'" />\
			</div>\
		');
		
		$('#meraki_orgs_'+k).append('<div class="meraki_right" id="meraki_org_output_'+orgs[k].id+'" ></div>');
		
		if ( orgs[k].administrator == "ERROR") {
			$('#meraki_org_'+orgs[k].id).attr('disabled','disabled');
		}
		
		if ( admin_exists ) {
			$.each ( admins[admin_to_add], function (j) {
				if ( admins[admin_to_add][j].id == orgs[k].id ) {
					$('#meraki_org_'+orgs[k].id).attr('disabled','disabled');
				}
			});
		}
	});
	$('#meraki_orgsOutput').append('\
		<div class="meraki_row">\
			<input type="button" class="meraki_button" name="meraki_go" id="meraki_go" value="Add to Selected Organisations" onclick="add_admin();">\
		</div>\
	');
	status_update('Waiting for user input...');
}
	
function add_admin() {
    status_update("Adding admins...");
	$("#meraki_go").hide();
	

	var fname = $("#meraki_full_name").val();
	var email = $("#meraki_email").val();
	var orgaccess = $("#meraki_access").val();
	
	$(':checkbox[name="org_checkboxes[]"]:checked').each( function () {
	var org_id = this.value;
	$('#meraki_org_output_'+org_id).html('Adding...');
		$.ajax({
			dataType: "json",
			url: "api.php",
			method: "post",
			data: {
				action: 	"add_org_admin",
				orgid:		org_id,
				key: 		key,
				fname: 		fname,
				email: 		email,
				orgaccess:	orgaccess
			},
			success: function (r) {on_add_admin_success(r, org_id);},
			error: function (x, s, e) {on_add_admin_error(e, org_id);}
		});
	});
}

function on_add_admin_success(r, org_id) {
	$('#meraki_org_output_'+org_id).html('Success')
}

function on_add_admin_error(e, org_id) {
	$('#meraki_org_output_'+org_id).html('Error: '+e)
}

//GET LICENCES

function get_licence_state() {
	
	status_update("Fetching organisations...");
	$(".meraki_form").hide();
	set_key();
	get_organisations(on_get_organisations_success_licences, on_get_organisations_error);	
}


function on_get_organisations_success_licences(data) {
	orgs = data;
	number_of_orgs = orgs.length;
	status_update("Found " + number_of_orgs + " organisations - fetching licence states...");
    $.each(data, function(org) {

        $.ajax({
            dataType: "json",
            url: "api.php",
			method: "post",
			data: {
				action:	"get_org_licences",
				orgid:	data[org].id,
				key:	key
			},
            success: function (r) {on_get_licence_sucess(r, org);},
            error: function (x, s, e) {on_get_licence_error(e, org);}
        });
	});
}

function on_get_licence_sucess(lic, org_index) {
	orgs[org_index].licStatus = lic['status'];
	orgs[org_index].licExpirationDate = Date.parse(lic['expirationDate']);
	orgs[org_index].licLicensedDeviceCounts = lic['licensedDeviceCounts'];	
	orgs_completed++;
    if(check_orgs_complete()) {
        print_licence_output();
    }
}

function on_get_licence_error(error, org_index) {
	orgs[org_index].licStatus = "ERROR";
	orgs[org_index].licExpirationDate = Date.parse(0);
	orgs[org_index].licLicensedDeviceCounts = "ERROR";
	orgs_completed++;
    if(check_orgs_complete()) {
        print_licence_output();
    }
}

function print_licence_output() {
	status_update('Sorting and generating output...');
	sorted = orgs.sort(function(a, b) { return a.licExpirationDate - b.licExpirationDate; });
	$("#meraki_licence_output").html('\
		<table id="licenceOutputTable">\
			<tr>\
				<td><b>Organisation</b></td>\
				<td><b>Status</b></td>\
				<td><b>Expiration Date</b></td>\
				<td><b>Devices</b></td>\
			</tr>\
		</table>\
	');
	$.each(sorted, function(data) {
		d = new Date(sorted[data].licExpirationDate);
		n = d.toDateString();
		$("#licenceOutputTable").append('\
			<tr>\
				<td>' + sorted[data].name + '</td>\
				<td>' + sorted[data].licStatus + '</td>\
				<td>' + n + '</td>\
				<td>'+ dump_licenced_devices(sorted[data].licLicensedDeviceCounts) + '</td>\
			</tr>\
		');		
	});
	status_update("Done...");
}

function dump_licenced_devices(data) {
	var i = 0;
	var list = '';
	if (data != 'ERROR'){
		for (type in data) {
			if ( i != 0 ) {
				list = list + '<br/>';
			}
			list = list + type + ' --> ' + data[type];
			i++;
		}
	}
	else {
		list = 'ERROR';
	}
	return list;
}



//GENERAL FUNCTIONS

function check_orgs_complete() {
    if( orgs_completed != number_of_orgs) { 
		status_update("Retrieved data for " + orgs_completed + " / " + number_of_orgs + " organisations - waiting for more data...");
        return false;
    }
    return true;
}

function do_this_when_all_loops_are_done() {
	status_update("Done...");
	//Output something?
}

function get_organisations(callback_success, callback_error) {
        $.ajax({
            dataType: "json",
            url: "api.php",
			method: "post",
			data: {
				action:	"get_orgs",
				key:	key
			},
            success: function(r) {callback_success(r);},
            error: function(x, s, e) {callback_error(e);}
        });     
}

function on_get_organisations_error (jqXHR, textStatus, errorThrown) {
	status_update("Error..." + errorThrown);
}

function group_orgs_by_admin () {
	var admins = {};
	$.each (orgs, function(j) {
		$.each (orgs[j].administrator, function (k) {
			if (orgs[j].administrator[k] != "ERROR") {
				var current_admin = orgs[j].administrator[k];
				if (!admins[current_admin.email]) {

					admins[current_admin.email]=[];
					
					admins[current_admin.email].name = current_admin.name;
				}

				var next_org = admins[current_admin.email].length;

				admins[current_admin.email][next_org]= { id: 			orgs[j].id,
														 name:			orgs[j].name,
														 orgAdminId: 	current_admin.id,
														orgAccess: 	current_admin.orgAccess
														};
				
			}
			
			
		});
	});
	return admins;
}

function status_update(t) {
    $("#meraki_status").html("<pre>Current status: " + t + "</pre>");
	return 1;
}

function set_key() {
 	if (!($("#meraki_ro_key").is(':checked'))) {
		key = $("#meraki_api_key").val();
	}
	else{
		key = "rokey";
	}
}