<?php

include 'config.php';

$page_header = file_get_contents ( "page_header.html" );
$page_footer = file_get_contents ( "page_footer.html" );

function ro_key_fields() { ?>
				<div class="meraki_row">
					<div class="meraki_left">
							<label for="meraki_ro_key">Use Read Only Key: </label>
					</div>
					<div class="meraki_right">
						<input type="checkbox" name="meraki_ro_key" id="meraki_ro_key" value="rokey" checked>
					</div>
				</div>
				<div class="meraki_row meraki_ro_key">
					<div class="meraki_left">
							<label for="merkai_api_key">Your API Key: </label>
					</div>
					<div class="meraki_right">
						<input type="password" name="meraki_api_key" id="meraki_api_key" length="40" />
					</div>
				</div>
<?php }

function rw_key_fields() { ?>
				<div class="meraki_row meraki_rw_key">
					<div class="meraki_left">
							<label for="merkai_api_key">Your API Key: </label>
					</div>
					<div class="meraki_right">
						<input type="checkbox" name="meraki_ro_key" id="meraki_ro_key" value="rokey" style="display:none" disabled>
						<input type="password" name="meraki_api_key" id="meraki_api_key" length="40" />
					</div>
				</div>
<?php }



	function parse_request() {
		global $RO_API_KEY;
		
		if ( !isset ( $_POST['key'] ) || $_POST['key'] == "" || $_POST['key'] == "rokey" ) {
			$key = $RO_API_KEY;
		}
		else {
			$key = $_POST['key'];
		}
		switch ($_POST['action']) {
			case "get_orgs":
				echo ( get_orgs($key) );
				break;
			case "get_org_licences":
				echo ( get_org_licences($_POST['orgid'], $key) );
				break;
			case "get_org_admins":
				echo ( get_org_admins($_POST['orgid'], $key) );
				break;
			case "add_org_admin":
				echo ( add_org_admin($_POST['orgid'], $_POST['fname'], $_POST['email'], $_POST['orgaccess'], $key) );
				break;
			case "delete_org_admin":
				echo ( delete_org_admin($_POST['orgid'], $_POST['adminid'], $key) );
				break;
			default:
				break;
		}
	}







	//Get a list of organisations
	function get_orgs($key) {
		return get_request('/organizations/', $key);
	}
	
	//Get a list of networks in an organisation
	function get_org_nets($orgid, $key) {
		return get_request('/organizations/' . $orgid . '/networks', $key);
	}

	//Get an array of licences for an organisation
	function get_org_licences($orgid, $key) {
		return get_request('/organizations/' . $orgid . '/licenseState', $key );
	}
		
	//Get a list of APs in a network
	function get_net_aps($netid, $key) {
		return get_request('/networks/' . $netid . '/devices', $key );
	}
	
	//Get a list of admins in an organisation
	function get_org_admins($orgid, $key) {
		return get_request('/organizations/' . $orgid . '/admins', $key );
	}
	//SAMPLE RESPONSE
	//[
	// {
	//	"id":"1",
	//	"name":"Miles Meraki",
	//	"email":"miles@meraki.com",
	//	"orgAccess":"none",
	//	"tags":[
	//	  {
	//		"tag":"west",
	//		"access":"read-only"
	//	  }
	//	],
	//	"networks":[
	//	  {
	//		"id":"N_249",
	//		"access":"full"
	//	  }
	//	]
	//  }
	//]
	
	//Add Admin
	//POST /organizations/[organization_id]/admins
	//sample post data:
	function add_org_admin($orgid, $name, $email, $access, $key) {
		$data = array ("name" => $name, "email" => $email, "orgAccess" => $access);
		$call = "/organizations/" . $orgid . "/admins/";
		return post_request($call, $data, $key);
	}
	
	//Delete an admin from an organisation
	function delete_org_admin($orgid, $adminid, $key) {
		return delete_request('/organizations/' . $orgid . '/admins/' . $adminid, $key);
	}

	
	
	
	
	//General function to submit a GET call
	function get_request($call, $key) {
		global $SERVER;
		global $API_VERSION;
	
		//TODO: Move to CURL

		$opts = array(
			'http'=>array(
				'method'	=>	"GET",
				'header'	=>	"X-Cisco-Meraki-API-Key: " . $key . "\r\n"
			)
		);

		$context = stream_context_create($opts);

		// Open the file using the HTTP headers set above
		$json = file_get_contents($SERVER . $API_VERSION . $call, false, $context);
		//TODO:  Catch exceptions and return errors
		$resp = preg_replace ( '/"id":([0-9]+),/', '"id":"$1",', $json );
		return $resp;
	}

	//General function to submit a POST call
	function post_request($call, $data, $key) {
		global $SERVER;
		global $API_VERSION;
		
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$SERVER . $API_VERSION . $call);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($data));  //Post Fields
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$headers = [	"X-Cisco-Meraki-API-Key: " . $key,
						"Content-type: application/json"
					];
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$json = curl_exec ($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		$resp = preg_replace ( '/"id":([0-9]+),/', '"id":"$1",', $json );
		curl_close ($ch);
		header('HTTP/1.1 ' . $httpcode);
		return $resp;
	}
	
	//General function to submit a DELETE call
	function delete_request($call, $key) {
		global $SERVER;
		global $API_VERSION;


		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$SERVER . $API_VERSION . $call);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$headers = [	"X-Cisco-Meraki-API-Key: " . $key,
						"Content-type: application/json"
					];
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$json = curl_exec ($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		$resp = preg_replace ( '/"id":([0-9]+),/', '"id":"$1",', $json );
		curl_close ($ch);
		header('HTTP/1.1 ' . $httpcode);
		return $resp;
	}
	
