<?php

include 'config.php';

$page_header = file_get_contents ( "page_header.html" );
$page_footer = file_get_contents ( "page_footer.html" );


	function parse_request() {
		global $RO_API_KEY;
		
		if ( !isset ( $_GET['key'] ) || $_GET['key'] == "" || $_GET['key'] == "rokey" ) {
			$key = $RO_API_KEY;
		}
		else {
			$key = $_GET['key'];
		}
		switch ($_GET['action']) {
			case "get_orgs":
				echo ( get_orgs($key) );
				break;
			case "get_org_licences":
				echo ( get_org_licences($_GET['orgid'], $key) );
				break;
		}
	}







	//Get a list of organisations
	function get_orgs($key) {
		return get_request('/organizations/', $key);
	}
	
	//Get a list of networks in an organisation
	function get_org_nets($orgid, $key) {
		return get_request('/organizations/' . $orgid . '/networks', $key);
	}

	//Get an array of licences for an organisation
	function get_org_licences($orgid, $key) {
		return get_request('/organizations/' . $orgid . '/licenseState', $key );
	}
		
	//Get a list of APs in a network
	function get_net_aps($netid, $key) {
		return get_request('/networks/' . $netid . '/devices', $key );
	}
	
	//Get a list of admins in an organisation
	function get_org_admins($orgid, $key) {
		return get_request('/organizations/' . $org_id . '/admins', $key );
	}
	//SAMPLE RESPONSE
	//[
	// {
	//	"id":"1",
	//	"name":"Miles Meraki",
	//	"email":"miles@meraki.com",
	//	"orgAccess":"none",
	//	"tags":[
	//	  {
	//		"tag":"west",
	//		"access":"read-only"
	//	  }
	//	],
	//	"networks":[
	//	  {
	//		"id":"N_249",
	//		"access":"full"
	//	  }
	//	]
	//  }
	//]
	
	//Add Admin
	//POST /organizations/[organization_id]/admins
	//sample post data:
	//{"name":"Miles Meraki", "email":"miles@meraki.com", "orgAccess":"none", "tags":[{"tag":"west", "access":"read-only"}]}
	
	//Delete an admin from an organisation
	function delete_org_admin($orgid, $adminid, $key) {
		return delete_request('/organizations/' . $orgid . '/admins/' . $adminid, $key);
	}
	
	
	
	
	
	//General function to submit a GET call
	function get_request($call, $key) {
		global $SERVER;
		global $API_VERSION;
		$opts = array(
			'http'=>array(
				'method'	=>	"GET",
				'header'	=>	"X-Cisco-Meraki-API-Key: " . $key . "\r\n"
			)
		);

		$context = stream_context_create($opts);

		// Open the file using the HTTP headers set above
		$json = file_get_contents($SERVER . $API_VERSION . $call, false, $context);
		//TODO:  Catch exceptions and return errors
		$resp = preg_replace ( '/"id":([0-9]+),/', '"id":"$1",', $json );
		return $resp;
	}

	//General function to submit a POST call
	function post_request($call, $post_data, $key) {
		global $SERVER;
		global $API_VERSION;
		$opts = array(
			'http'=>array(
				'method'	=>	"POST",
				'header'	=>	"X-Cisco-Meraki-API-Key: " . $key . "\r\n" .
								"Content-type: application/x-www-form-urlencoded\r\n",
				'content'	=>	$post_data
			)
		);

		$context = stream_context_create($opts);

		// Open the file using the HTTP headers set above
		$json = file_get_contents($SERVER . $API_VERSION . $call, false, $context);
		//TODO:  Catch exceptions and return errors
		$resp = preg_replace ( '/"id":([0-9]+),/', '"id":"$1",', $json );
		return $resp;
	}
	
	//General function to submit a DELETE call
	function delete_request($call, $key) {
		global $SERVER;
		global $API_VERSION;
		$opts = array(
			'http'=>array(
				'method'	=>	"DELETE",
				'header'	=>	"X-Cisco-Meraki-API-Key: " . $key . "\r\n"
			)
		);

		$context = stream_context_create($opts);

		// Open the file using the HTTP headers set above
		$json = file_get_contents($SERVER . $API_VERSION . $call, false, $context);
		//TODO:  Catch exceptions and return errors
		//Successful HTTP Status: 204
		//Return HTTP Code
		return $resp;
	}
	
