<?php

// Main PHP file containing most of the functionality required

// Populate configuration variables with local values
include 'config.php';

// Load in the header and footer for the HTML pages
$page_header = file_get_contents ( "page_header.html" );
$page_footer = file_get_contents ( "page_footer.html" );

// Function to add a row to the forms with the standard fields for
// The API key where using the built in read only key would be acceptable
function ro_key_fields() { ?>
				<div class="meraki_row">
					<div class="meraki_left">
							<label for="meraki_ro_key">Use Read Only Key: </label>
					</div>
					<div class="meraki_right">
						<input type="checkbox" name="meraki_ro_key" id="meraki_ro_key" value="rokey" checked>
					</div>
				</div>
				<div class="meraki_row meraki_ro_key">
					<div class="meraki_left">
							<label for="merkai_api_key">Your API Key: </label>
					</div>
					<div class="meraki_right">
						<input type="password" name="meraki_api_key" id="meraki_api_key" length="40" />
					</div>
				</div>
<?php }

// Function to add a row to the forms with the standard fields for
// The API key where using the built in read only key would NOT be acceptable
// This is generally where people need to make changes
function rw_key_fields() { ?>
				<div class="meraki_row meraki_rw_key">
					<div class="meraki_left">
							<label for="merkai_api_key">Your API Key: </label>
					</div>
					<div class="meraki_right">
						<input type="checkbox" name="meraki_ro_key" id="meraki_ro_key" value="rokey" style="display:none" disabled>
						<input type="password" name="meraki_api_key" id="meraki_api_key" length="40" />
					</div>
				</div>
<?php }


	// Parse API calls
	function parse_request() {
		global $RO_API_KEY;
	
		// If a key is sent, use that one, otherwise use the readonly key	
		if ( !isset ( $_POST['key'] ) || $_POST['key'] == "" || $_POST['key'] == "rokey" ) {
			$key = $RO_API_KEY;
		}
		else {
			$key = $_POST['key'];
		}
		
		// Truncate the key for logging so we can see who's using who's key
		$truncated_key = preg_replace ( '/^[0-9a-fA-F]{36}/', '******', $key );
		
		// Switch on the action requested, log the request and reply with the return value of the appropriate function
		switch ($_POST['action']) {
			case "get_orgs":
				error_log("Username: " . $_SERVER['REMOTE_USER'] . " Key: " . $truncated_key . " Action: " . $_POST['action'], 0);
				echo ( get_orgs($key) );
				break;
			case "get_org_licences":
				error_log("Username: " . $_SERVER['REMOTE_USER'] . " Key: " . $truncated_key . " Action: " . $_POST['action'], 0);
				echo ( get_org_licences($_POST['orgid'], $key) );
				break;
			case "get_org_admins":
				error_log("Username: " . $_SERVER['REMOTE_USER'] . " Key: " . $truncated_key . " Action: " . $_POST['action'], 0);
				echo ( get_org_admins($_POST['orgid'], $key) );
				break;
			case "get_org_networks":
				error_log("Username: " . $_SERVER['REMOTE_USER'] . " Key: " . $truncated_key . " Action: " . $_POST['action'], 0);
				echo ( get_org_networks($_POST['orgid'], $key) );
				break;
			case "get_network_devices":
				error_log("Username: " . $_SERVER['REMOTE_USER'] . " Key: " . $truncated_key . " Action: " . $_POST['action'], 0);
				echo ( get_network_devices($_POST['orgid'], $_POST['networkid'], $key) );
				break;
			case "add_org_admin":
				error_log("Username: " . $_SERVER['REMOTE_USER'] . " Key: " . $truncated_key . " Action: " . $_POST['action'], 0);
				error_log("orgid: " . $_POST['orgid'] . " Name: " . $_POST['fname'] . " Email: " . $_POST['email'] . " OrgAccess: " . $_POST['orgaccess'], 0);
				echo ( add_org_admin($_POST['orgid'], $_POST['fname'], $_POST['email'], $_POST['orgaccess'], $key) );
				break;
			case "delete_org_admin":
				error_log("Username: " . $_SERVER['REMOTE_USER'] . " Key: " . $truncated_key . " Action: " . $_POST['action'], 0);
				error_log("orgid: " . $_POST['orgid'] . " Adminid: " . $_POST['adminid']);
				echo ( delete_org_admin($_POST['orgid'], $_POST['adminid'], $key) );
				break;
			default:
				break;
		}
	}







	// Get a list of organisations
	function get_orgs($key) {
		return get_request('/organizations/', $key);
	}
	
	// Get a list of networks in an organisation
	function get_org_networks($orgid, $key) {
		return get_request('/organizations/' . $orgid . '/networks', $key);
	}
	
	// Get a list of devices in an organisation
	function get_network_devices($orgid, $netid, $key) {
		return get_request('/networks/' . $netid . '/devices', $key);
	}

	// Get an array of licences for an organisation
	function get_org_licences($orgid, $key) {
		return get_request('/organizations/' . $orgid . '/licenseState', $key );
	}
		
	// Get a list of APs in a network
	function get_net_aps($netid, $key) {
		return get_request('/networks/' . $netid . '/devices', $key );
	}
	
	// Get a list of admins in an organisation
	function get_org_admins($orgid, $key) {
		return get_request('/organizations/' . $orgid . '/admins', $key );
	}
	
	// Add and admin to and organisation
	function add_org_admin($orgid, $name, $email, $access, $key) {
		$data = array ("name" => $name, "email" => $email, "orgAccess" => $access);
		$call = "/organizations/" . $orgid . "/admins/";
		return post_request($call, $data, $key);
	}
	
	// Delete an admin from an organisation
	function delete_org_admin($orgid, $adminid, $key) {
		return delete_request('/organizations/' . $orgid . '/admins/' . $adminid, $key);
	}

	
	
	
	
	// General function to submit a GET call
	function get_request($call, $key) {
		global $SERVER;
		global $API_VERSION;
	
		// TODO: Move to CURL

		$opts = array(
			'http'=>array(
				'method'	=>	"GET",
				'header'	=>	"X-Cisco-Meraki-API-Key: " . $key . "\r\n"
			)
		);

		$context = stream_context_create($opts);

		// Open the file using the HTTP headers set above
		$json = file_get_contents($SERVER . $API_VERSION . $call, false, $context);
		// TODO:  Catch exceptions and return errors

		// Sanitise the ID for Javascript (enclose in " so it's a string rather than a number)
		$resp = preg_replace ( '/"id":([0-9]+),/', '"id":"$1",', $json );
		return $resp;
	}

	// General function to submit a POST call
	function post_request($call, $data, $key) {

		// Use the values defined in the config.php file
		global $SERVER;
		global $API_VERSION;
		
		// Initialise curl
		$ch = curl_init();

		// Set the request URL
		curl_setopt($ch, CURLOPT_URL,$SERVER . $API_VERSION . $call);
		// Define a POST request
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		// Follow redirects
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		// Encode the data to be sent and attach to the request
		curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($data));
		// Return the result of request instead of Truse/False
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Define request headers
		$headers = [	"X-Cisco-Meraki-API-Key: " . $key,
						"Content-type: application/json"
					];

		// Attach the headers to the request
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		// Execute the curl request and get the returned data and HTTP code
		$json = curl_exec ($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		// Sanitise the ID for Javascript (enclose in " so it's a string rather than a number)
		$resp = preg_replace ( '/"id":([0-9]+),/', '"id":"$1",', $json );

		error_log("url: " . $SERVER . $API_VERSION . $call . " data: " . json_encode($data) . " http code: " . $httpcode . " Response: " . $resp, 0);

		// Tidy up
		curl_close ($ch);

		// Send the return code back to the requesting browser
		header('HTTP/1.1 ' . $httpcode);

		// Send any data we may or may not have
		return $resp;
	}
	
	//General function to submit a DELETE call
	function delete_request($call, $key) {

		// Use the values defined in the config.php file
		global $SERVER;
		global $API_VERSION;


		// Initialise curl
		$ch = curl_init();

		// Set the request URL
		curl_setopt($ch, CURLOPT_URL,$SERVER . $API_VERSION . $call);
		// Define a DELETE request
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
		// Follow redirects
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		// Return the result of request instead of Truse/False
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		// Define request headers
		$headers = [	"X-Cisco-Meraki-API-Key: " . $key,
						"Content-type: application/json"
					];

		// Attach the headers to the request
		curl_setopt($ch, CURLOPT_HEADER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		// Execute the curl request and get the returned data and HTTP code
		$json = curl_exec ($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		// Sanitise the ID for Javascript (enclose in " so it's a string rather than a number)
		$resp = preg_replace ( '/"id":([0-9]+),/', '"id":"$1",', $json );

		// Tidy up
		curl_close ($ch);

		// Send the return code back to the requesting browser
		header('HTTP/1.1 ' . $httpcode);

		// Send any data we may or may not have
		return $resp;
	}
	
