var orgs;
var nets;
var number_of_orgs;
var number_of_nets;
var orgs_completed=0;
var nets_completed=0;
var current_org=-1;
var key="";

$( document ).ready(function() {
	$("#meraki_ro_key").change(function(event) {
		var checkbox = event.target;
		if (checkbox.checked) {
			$(".meraki_ro_key").hide();
		} else {
			$(".meraki_ro_key").css('display', 'table-row');
		}
	});
});


//ADMIN FUNCTIONS

function get_admins_by_org() {
    status_update("Fetching organisations...");
	$(".meraki_form").hide();
	set_key();
    get_organisations(on_get_organisations_success_admins, on_get_organisations_error);
}


function on_get_organisations_success_admins(data) {
	orgs = data;
	number_of_orgs = orgs.length;
	status_update("Found " + number_of_orgs + " organisations - fetching admins...");
    $.each(data, function(org) {

        $.ajax({
            dataType: "json",
            url: "api.php",
			method: "post",
			data: {
				action: "get_org_admins",
				orgid: 	data[org].id,
				key: 	key
			},
            success: function (r) {on_get_admin_sucess(r, org);},
            error: function (x, s, e) {on_get_admin_error(e, org);}
        });
	});
}

function on_get_admin_sucess(administrator, org_index) {
    orgs[org_index].administrator = administrator;
	orgs_completed++;
    if(check_orgs_complete()) {
        print_admins_output();
    }
}

function on_get_admin_error(error, org_index) {
    orgs[org_index].administrator = [];
	orgs[org_index].administrator[0] = "ERROR";
	orgs_completed++;
    if(check_orgs_complete()) {
        print_admins_output();
    }
}

function print_admins_output() {
	if ( page == "orgs_by_admin" ){
		print_admins_output_by_admin();
	}
	else if ( page == "admins_by_org" ) {
		print_admins_output_by_org();
	}
	else if ( page == "add_admin" ) {
		print_orgs_to_add_admin();
	}
	else if ( page == "delete_admin" ) {
		print_select_admin_to_remove();
	}
	else {
		status_update("Errrrrr - this shouldn't ever be reached - something went very wrong!");
	}
}

function print_admins_output_by_org() {
	status_update('Sorting and generating output...');
	sorted = orgs.sort(function(a, b) { return a.name - b.name; });
	$("#meraki_admins_output").html('\
		<table class="meraki_output_table" id="meraki_admins_output_table">\
			<tr>\
				<td class="meraki_output_header_group"><b>Organisation</b></td>\
				<td class="meraki_output_header"><b>Name</b></td>\
				<td class="meraki_output_header"><b>Email Address</b></td>\
				<td class="meraki_output_header"><b>Access Level</b></td>\
			</tr>\
		</table>\
	');
	$.each(sorted, function(data) {
		if ( sorted[data].administrator[0] != "ERROR" ) {
			number_of_admins = sorted[data].administrator.length;
			$("#meraki_admins_output_table").append('\
				<tr>\
					<td rowspan="'+number_of_admins+'" class="meraki_output_group">' + sorted[data].name + '</td>\
					<td>' + sorted[data].administrator[0].name + '</td>\
					<td>' + sorted[data].administrator[0].email + '</td>\
					<td>' + sorted[data].administrator[0].orgAccess + '</td>\
				</tr>\
			');
			for (i=1; i<number_of_admins; i++) {
				$("#meraki_admins_output_table").append('\
					<tr>\
						<td>' + sorted[data].administrator[i].name + '</td>\
						<td>' + sorted[data].administrator[i].email + '</td>\
						<td>' + sorted[data].administrator[i].orgAccess + '</td>\
					</tr>\
				');
			}
		}
		else {
			$("#meraki_admins_output_table").append('\
				<tr>\
					<td class="meraki_output_group">' + sorted[data].name + '</td>\
					<td>ERROR</td>\
					<td>ERROR</td>\
					<td>ERROR</td>\
				</tr>\
			');
		}
	});
	status_update("Done...");
}

function print_admins_output_by_admin() {
	status_update('Sorting and generating output...');
	
	admins = group_orgs_by_admin();
	
	sorted = admins; //.sort(function(a, b) { return a.name - b.name; });
	$("#meraki_admins_output").html('\
		<table class="meraki_output_table" id="meraki_admins_output_table">\
			<tr>\
				<td class="meraki_output_header_group"><b>Email Address</b></td>\
				<td class="meraki_output_header_group"><b>Name</b></td>\
				<td class="meraki_output_header"><b>Organisation</b></td>\
				<td class="meraki_output_header"><b>Access Level</b></td>\
			</tr>\
		</table>\
	');
	$.each(sorted, function(j) {
		number_of_admins = sorted[j].length;
		$("#meraki_admins_output_table").append('\
			<tr>\
				<td rowspan="'+number_of_admins+'" class="meraki_output_group">' + j + '</td>\
				<td rowspan="'+number_of_admins+'" class="meraki_output_group">' + sorted[j].name + '</td>\
				<td>' + sorted[j][0].name + '</td>\
				<td>' + sorted[j][0].orgAccess + '</td>\
			</tr>\
		');
		for (i=1; i<number_of_admins; i++) {
			$("#meraki_admins_output_table").append('\
				<tr>\
					<td>' + sorted[j][i].name + '</td>\
					<td>' + sorted[j][i].orgAccess + '</td>\
				</tr>\
			');
		}
	});
	status_update("Done...");
}

function print_orgs_to_add_admin() {
	status_update('Sorting and generating output...');
	
	sorted = orgs.sort(function(a, b) { return (a.name < b.name)?-1:((b.name < a.name)?1:0); });
	orgs = sorted;

	admins = group_orgs_by_admin();
	
	//check if admin exists - if not we can skip the per org checks
	var admin_to_add = $('#meraki_email').val();
	var admin_exists;
	if ( ! (admins[admin_to_add] ) ){
		admin_exists=false;
	}
	else {
		admin_exists = true;
	}
	
	$('#meraki_orgsOutput').append('\
		<div class="meraki_row"><p>Please select the organisations to add this user to:</p></div>\
	');
	
	$.each (orgs, function (k) {
		$('#meraki_orgsOutput').append('<div class="meraki_row" id="meraki_orgs_'+k+'"></div>');
		$('#meraki_orgs_'+k).append('\
			<div class="meraki_left">\
				<label for="meraki_org_'+orgs[k].id+'">\
					'+orgs[k].name+'\
				</label>\
			</div>\
		');
		$('#meraki_orgs_'+k).append('\
			<div class="meraki_middle">\
				<input type="checkbox" name="org_checkboxes[]" value="'+orgs[k].id+'" id="meraki_org_'+orgs[k].id+'" />\
			</div>\
		');
		
		$('#meraki_orgs_'+k).append('<div class="meraki_right" id="meraki_org_output_'+orgs[k].id+'" ></div>');
		
		if ( orgs[k].administrator == "ERROR") {
			$('#meraki_org_'+orgs[k].id).attr('disabled','disabled');
			$('#meraki_org_output_'+orgs[k].id).html('Unable to read data');
			$('#meraki_org_output_'+orgs[k].id).addClass('meraki_failure');
		}
		
		if ( admin_exists ) {
			$.each ( admins[admin_to_add], function (j) {
				if ( admins[admin_to_add][j].id == orgs[k].id ) {
					$('#meraki_org_'+orgs[k].id).attr('disabled','disabled');
					$('#meraki_org_output_'+orgs[k].id).html('Already an admin ('+admins[admin_to_add][j].orgAccess+')');
					$('#meraki_org_output_'+orgs[k].id).addClass('meraki_success');
				}
			});
		}
	});
	$('#meraki_orgsOutput').append('\
		<div class="meraki_row">\
			<input type="button" class="meraki_button" name="meraki_go" id="meraki_go" value="Add to Selected Organisations" onclick="add_admin();">\
		</div>\
	');
	status_update('Waiting for user input...');
}
	
function add_admin() {
    status_update("Adding admins...");
	$("#meraki_go").hide();
	

	var fname = $("#meraki_full_name").val();
	var email = $("#meraki_email").val();
	var orgaccess = $("#meraki_access").val();
	
	$(':checkbox[name="org_checkboxes[]"]:checked').each( function () {
	var org_id = this.value;
	$('#meraki_org_output_'+org_id).html('Adding...');
		$.ajax({
			dataType: "json",
			url: "api.php",
			method: "post",
			data: {
				action: 	"add_org_admin",
				orgid:		org_id,
				key: 		key,
				fname: 		fname,
				email: 		email,
				orgaccess:	orgaccess
			},
			success: function (r) {on_add_admin_success(r, org_id);},
			error: function (x, s, e) {on_add_admin_error(e, org_id);}
		});
	});
}

function on_add_admin_success(r, org_id) {
	$('#meraki_org_output_'+org_id).html('Success')
	$('#meraki_org_output_'+org_id).addClass('meraki_success');
}

function on_add_admin_error(e, org_id) {
	$('#meraki_org_output_'+org_id).html('Error: '+e);
	$('#meraki_org_output_'+org_id).addClass('meraki_failure');
}

function print_select_admin_to_remove() {
	status_update('Sorting and generating output...');
	
	admins = group_orgs_by_admin();
	
	$('#meraki_admins_output').html('<select id="meraki_admin" name="meraki_admin"></select>');
	
	$.each ( admins, function (j) {
		$('#meraki_admin').append('<option value="'+j+'">'+j+' ('+this.name+')</option>');
	});
	
	$('#meraki_admins_output').append('\
		<div class="meraki_row">\
			<input type="button" class="meraki_button" name="meraki_next2" id="meraki_next2" value="Next" onclick="get_orgs_for_admin();"\
		</div>\
	');
	status_update('Waiting for user input...');
}

function get_orgs_for_admin() {
	status_update('Sorting and generating output...');
	
	$('#meraki_admins_output').hide();
	
	var admin_to_remove = $('#meraki_admin').val();
	
	sorted = orgs.sort(function(a, b) { return (a.name < b.name)?-1:((b.name < a.name)?1:0); });
	orgs = sorted;

	admins = group_orgs_by_admin();
	
	$('#meraki_orgs_output').append('\
		<div class="meraki_row"><p>Please select the organisations to remove this user from:</p></div>\
	');
	
	$.each (orgs, function (k) {
		$('#meraki_orgs_output').append('<div class="meraki_row" id="meraki_orgs_'+k+'"></div>');
		$('#meraki_orgs_'+k).append('\
			<div class="meraki_left">\
				<label for="meraki_org_'+orgs[k].id+'">\
					'+orgs[k].name+'\
				</label>\
			</div>\
		');
		$('#meraki_orgs_'+k).append('\
			<div class="meraki_middle">\
				<input type="checkbox" name="org_checkboxes[]" value="'+orgs[k].id+'" id="meraki_org_'+orgs[k].id+'" disabled />\
			</div>\
		');
		
		$('#meraki_orgs_'+k).append('<div class="meraki_right" id="meraki_org_output_'+orgs[k].id+'" ></div>');
		$('#meraki_org_output_'+orgs[k].id).html('Not an admin');
		$('#meraki_org_output_'+orgs[k].id).addClass('meraki_success');
		$('#meraki_orgs_'+k).hide();
		
		if ( orgs[k].administrator == "ERROR") {
			$('#meraki_org_'+orgs[k].id).attr('disabled','disabled');
			$('#meraki_org_output_'+orgs[k].id).html('Unable to read data');
			$('#meraki_org_output_'+orgs[k].id).addClass('meraki_failure');
			$('#meraki_orgs_'+k).hide();
		}
		
		$.each ( admins[admin_to_remove], function (j) {
			if ( admins[admin_to_remove][j].id == orgs[k].id ) {
				$('#meraki_org_'+orgs[k].id).removeAttr('disabled');
				$('#meraki_orgs_'+k).css('display', 'table-row');
				$('#meraki_org_'+orgs[k].id).val(orgs[k].id + ':' + admins[admin_to_remove][j].orgAdminId)
				$('#meraki_org_output_'+orgs[k].id).html('');
				$('#meraki_org_output_'+orgs[k].id).removeClass('meraki_success');
			}
		});
	});
	$('#meraki_orgs_output').append('\
		<div class="meraki_row">\
			<input type="button" class="meraki_button class meraki_button_warning" name="meraki_go" id="meraki_go" value="DELETE from Selected Organisations" onclick="remove_admin();">\
		</div>\
	');
	status_update('Waiting for user input...');
}

function remove_admin() {
    status_update("Removing admin...");
	$("#meraki_go").hide();
	

	$(':checkbox[name="org_checkboxes[]"]:checked').each( function () {
	var ids = this.value.split(':');
	var org_id = ids[0];
	var admin_id = ids[1];
	$('#meraki_org_output_'+org_id).html('Removing...');
		$.ajax({
			dataType: "json",
			url: "api.php",
			method: "post",
			data: {
				action: 	"delete_org_admin",
				orgid:		org_id,
				adminid:	admin_id
			},
			success: function (r) {on_del_admin_success(r, org_id);},
			error: function (x, s, e) {on_del_admin_error(e, org_id);}
		});
	});
}

function on_del_admin_success(r, org_id) {
	$('#meraki_org_output_'+org_id).html('Success')
	$('#meraki_org_output_'+org_id).addClass('meraki_success');
}

function on_del_admin_error(e, org_id) {
	$('#meraki_org_output_'+org_id).html('Error: '+e);
	$('#meraki_org_output_'+org_id).addClass('meraki_failure');
}


//GET INVENTORY

function get_inv_orgs() {
	
	status_update("Fetching organisations...");
	$(".meraki_form").hide();
	set_key();
	get_organisations(on_get_organisations_success_inventory, on_get_organisations_error);	
}

function on_get_organisations_success_inventory(data) {
	status_update('Sorting and generating output...');

	orgs = data;
	sorted = orgs.sort(function(a, b) { return (a.name < b.name)?-1:((b.name < a.name)?1:0); });
	
	
	$('#meraki_orgs_output').html('<select id="meraki_org" name="meraki_org"></select>');
	
	$.each ( orgs, function (j) {
		$('#meraki_org').append('<option value="'+this.id+'">'+this.name+'</option>');
	});
	
	$('#meraki_orgs_output').append('\
		<div class="meraki_row">\
			<input type="button" class="meraki_button" name="meraki_go" id="meraki_go" value="Get Inventory" onclick="get_inventory();">\
		</div>\
	');
	status_update('Waiting for user input...');
}

function get_inventory() {
	status_update("Fetching networks...");
	$('#meraki_orgs_output').hide();
	var orgid=$('#meraki_org').val();
	$.ajax({
		dataType: "json",
		url: "api.php",
		method: "post",
		data: {
			action:	"get_org_networks",
			orgid:	orgid,
			key:	key
		},
		success: function (r) {on_get_network_success(r, orgid);},
		error: function (x, s, e) {on_get_network_error(e, orgid);}
	});
}

function on_get_network_success(r, orgid) {
	nets = r;
	number_of_nets = nets.length;
	status_update("Found " + number_of_nets + " networks - fetching device details...");
	
    $.each(r, function(network) {
        $.ajax({
            dataType: "json",
            url: "api.php",
			method: "post",
			data: {
				action:	"get_network_devices",
				orgid:	orgid,
				networkid: this.id,
				key:	key
			},
            success: function (r) {on_get_devices_success(r, network);},
            error: function (x, s, e) {on_get_devices_error(e, network);}
        });
	});
}

function on_get_devices_success(devices, net_index) {
	nets[net_index].devices = devices;
	nets_completed++;
    if(check_nets_complete()) {
        print_inventory_output();
	}
}

function on_get_network_error(e, net_index) {
	status_update("Error fetching networks: " + e);
}

function on_get_devices_error(e, net_index) {
	status_update("Error fetching devices: " + e);
	nets[net_index].devices = ["ERROR"];
	nets_completed++;
    if(check_nets_complete()) {
        print_inventory_output();
    }
}

function  print_inventory_output() {
	status_update('Sorting and generating output...');
	
	var csv="Network Name,Network Type,Device Name,Device Serial,Device Model,Device IP,Device MAC\r\n";
	
	sorted = nets; //.sort(function(a, b) { return a.name - b.name; });
	$("#meraki_inventory_output").html('\
		<table class="meraki_output_table" id="meraki_inventory_output_table">\
			<tr>\
				<td class="meraki_output_header_group"><b>Network Name</b></td>\
				<td class="meraki_output_header_group"><b>Network Type</b></td>\
				<td class="meraki_output_header"><b>Device Name</b></td>\
				<td class="meraki_output_header"><b>Device Serial</b></td>\
				<td class="meraki_output_header"><b>Device Model</b></td>\
				<td class="meraki_output_header"><b>Device IP</b></td>\
				<td class="meraki_output_header"><b>Device MAC</b></td>\
			</tr>\
		</table>\
	');
	$.each(sorted, function(j) {
		devices = sorted[j].devices;
		number_of_devices = devices.length;
		if ( number_of_devices > 0 ) {
			$("#meraki_inventory_output_table").append('\
				<tr>\
					<td rowspan="'+number_of_devices+'" class="meraki_output_group">' + this.name + '</td>\
					<td rowspan="'+number_of_devices+'" class="meraki_output_group">' + this.type + '</td>\
					<td>' + devices[0].name + '</td>\
					<td>' + devices[0].serial + '</td>\
					<td>' + devices[0].model + '</td>\
					<td>' + devices[0].lanIp + '</td>\
					<td>' + devices[0].mac + '</td>\
				</tr>\
			');
			csv = csv + ([this.name, this.type, devices[0].name, devices[0].serial, devices[0].model, devices[0].lanIp, devices[0].mac].join()) + "\r\n";
			for (i=1; i<number_of_devices; i++) {
				$("#meraki_inventory_output_table").append('\
					<tr>\
						<td>' + devices[i].name + '</td>\
						<td>' + devices[i].serial + '</td>\
						<td>' + devices[i].model + '</td>\
						<td>' + devices[i].lanIp + '</td>\
						<td>' + devices[i].mac + '</td>\
					</tr>\
				');
				csv = csv + ([sorted[j].name, sorted[j].type, devices[i].name, devices[i].serial, devices[i].model, devices[i].lanIp, devices[i].mac].join()) + "\r\n";
			}
		}
		else {
			$("#meraki_inventory_output_table").append('\
				<tr>\
					<td class="meraki_output_group">' + this.name + '</td>\
					<td class="meraki_output_group">' + this.type + '</td>\
					<td>No devices found</td>\
					<td></td>\
					<td></td>\
					<td></td>\
					<td></td>\
				</tr>\
			');
		}
	});
	$("#meraki_inventory_output").append('<p><br/><br/>Please find below in CSV format:</p>');
	$("#meraki_inventory_output").append('<textarea name="meraki_inventory_csv_output" id="meraki_inventory_csv_output" style="width:100%" rows="50" ></textarea>');
	$('#meraki_inventory_csv_output').text(csv);
	status_update("Done...");
}

function check_nets_complete() {
    if( nets_completed != number_of_nets) { 
		status_update("Retrieved data for " + nets_completed + " / " + number_of_nets + " networks - waiting for more data...");
        return false;
    }
    return true;
}

//GET LICENCES

function get_licence_state() {
	
	status_update("Fetching organisations...");
	$(".meraki_form").hide();
	set_key();
	get_organisations(on_get_organisations_success_licences, on_get_organisations_error);	
}


function on_get_organisations_success_licences(data) {
	orgs = data;
	number_of_orgs = orgs.length;
	status_update("Found " + number_of_orgs + " organisations - fetching licence states...");
    $.each(data, function(org) {

        $.ajax({
            dataType: "json",
            url: "api.php",
			method: "post",
			data: {
				action:	"get_org_licences",
				orgid:	data[org].id,
				key:	key
			},
            success: function (r) {on_get_licence_sucess(r, org);},
            error: function (x, s, e) {on_get_licence_error(e, org);}
        });
	});
}

function on_get_licence_sucess(lic, org_index) {
	orgs[org_index].licStatus = lic['status'];
	orgs[org_index].licExpirationDate = Date.parse(lic['expirationDate']);
	orgs[org_index].licLicensedDeviceCounts = lic['licensedDeviceCounts'];	
	orgs_completed++;
    if(check_orgs_complete()) {
        print_licence_output();
    }
}

function on_get_licence_error(error, org_index) {
	orgs[org_index].licStatus = "ERROR";
	orgs[org_index].licExpirationDate = Date.parse(0);
	orgs[org_index].licLicensedDeviceCounts = "ERROR";
	orgs_completed++;
    if(check_orgs_complete()) {
        print_licence_output();
    }
}

function print_licence_output() {
	status_update('Sorting and generating output...');
	sorted = orgs.sort(function(a, b) { return a.licExpirationDate - b.licExpirationDate; });
	$("#meraki_licence_output").html('\
		<table id="merkai_licence_output_table">\
			<tr>\
				<td class="meraki_output_header_group"><b>Organisation</b></td>\
				<td class="meraki_output_header_group"><b>Status</b></td>\
				<td class="meraki_output_header_group"><b>Expiration Date</b></td>\
				<td class="meraki_output_header_group"><b>Device Type</b></td>\
				<td class="meraki_output_header_group"><b>Device Count</b></td>\
			</tr>\
		</table>\
	');
	$.each(sorted, function(data) {
		d = new Date(sorted[data].licExpirationDate);
		n = d.toDateString();
		licenced_devices = dump_licenced_devices(sorted[data].licLicensedDeviceCounts);
		number_of_types=licenced_devices.length;
		var status_class = '';
		switch (sorted[data].licStatus) {
			case "ERROR":
			case "Expired":
				status_class = 'meraki_failure';
				break;
			case "License Expires Soon":
				status_class = 'meraki_warning';
				break;
			case "OK":
				status_class = 'meraki_success';
				break;
			default:
				break;
		}
		
		$("#merkai_licence_output_table").append('\
			<tr>\
				<td rowspan="'+number_of_types+'" class="meraki_output_group">' + sorted[data].name + '</td>\
				<td rowspan="'+number_of_types+'" class="meraki_output_group ' + status_class + '">' + sorted[data].licStatus + '</td>\
				<td rowspan="'+number_of_types+'" class="meraki_output_group">' + n + '</td>\
				<td class="meraki_output_group">'+ licenced_devices[0].type + '</td>\
				<td class="meraki_output_group">'+ licenced_devices[0].count + '</td>\
			</tr>\
		');	
		for (i=1; i<number_of_types; i++) {
			$("#merkai_licence_output_table").append('\
				<tr>\
					<td class="meraki_output_group">' + licenced_devices[i].type + '</td>\
					<td class="meraki_output_group">' + licenced_devices[i].count + '</td>\
				</tr>\
			');
		}
	});
	status_update("Done...");
}

function dump_licenced_devices(data) {
	var i = 0;
	var list = [];
	if (data != 'ERROR'){
		for (type in data) {
			list[i] = { type: type, count: data[type] };
			i++;
		}
	}
	else {
		list[i] = {type:'ERROR', count:'ERROR'};
	}
	return list;
}



//GENERAL FUNCTIONS

function check_orgs_complete() {
    if( orgs_completed != number_of_orgs) { 
		status_update("Retrieved data for " + orgs_completed + " / " + number_of_orgs + " organisations - waiting for more data...");
        return false;
    }
    return true;
}


function do_this_when_all_loops_are_done() {
	status_update("Done...");
}

function get_organisations(callback_success, callback_error) {
        $.ajax({
            dataType: "json",
            url: "api.php",
			method: "post",
			data: {
				action:	"get_orgs",
				key:	key
			},
            success: function(r) {callback_success(r);},
            error: function(x, s, e) {callback_error(e);}
        });     
}

function on_get_organisations_error (jqXHR, textStatus, errorThrown) {
	status_update("Error..." + errorThrown);
}

function group_orgs_by_admin () {
	var admins = {};
	$.each (orgs, function(j) {
		$.each (orgs[j].administrator, function (k) {
			if (orgs[j].administrator[k] != "ERROR") {
				var current_admin = orgs[j].administrator[k];
				if (!admins[current_admin.email]) {

					admins[current_admin.email]=[];
					
					admins[current_admin.email].name = current_admin.name;
				}

				var next_org = admins[current_admin.email].length;

				admins[current_admin.email][next_org]= { id: 			orgs[j].id,
														 name:			orgs[j].name,
														 orgAdminId: 	current_admin.id,
														orgAccess: 	current_admin.orgAccess
														};
				
			}
			
			
		});
	});
	return admins;
}

function status_update(t) {
    $("#meraki_status").html("<pre>Current status: " + t + "</pre>");
	return 1;
}

function set_key() {
 	if (!($("#meraki_ro_key").is(':checked'))) {
		key = $("#meraki_api_key").val();
	}
	else{
		key = "rokey";
	}
}
