// Variable to hold fetched organisations
var orgs;

// Variable to hold fetched networks
var nets;

// Number of Organisations expected
var number_of_orgs;

// Number of Networks expected
var number_of_nets;

// Number of Organisations fetched
var orgs_completed=0;

// Number of Networks fetched
var nets_completed=0;

// API Key
var key="";

//Rate limit APIs to 1 every xxx ms
var ratelimit=600;

//Extend _ with rate limit method:
_.rateLimit = function(func, rate, async) {
  var queue = [];
  var timeOutRef = false;
  var currentlyEmptyingQueue = false;
  
  var emptyQueue = function() {
    if (queue.length) {
      currentlyEmptyingQueue = true;
      _.delay(function() {
        if (async) {
          _.defer(function() { queue.shift().call(); });
        } else {
          queue.shift().call();
        }
        emptyQueue();
      }, rate);
    } else {
      currentlyEmptyingQueue = false;
    }
  };
  
  return function() {
    var args = _.map(arguments, function(e) { return e; }); // get arguments into an array
    queue.push( _.bind.apply(this, [func, this].concat(args)) ); // call apply so that we can pass in arguments as parameters as opposed to an array
    if (!currentlyEmptyingQueue) { emptyQueue(); }
  };
};

// Initialisation functions
$( document ).ready(function() {

	// Add a handler to hide and show API key when a read only key is allowed
	$("#meraki_ro_key").change(function(event) {
		var checkbox = event.target;
		if (checkbox.checked) {
			$(".meraki_ro_key").hide();
		} else {
			// Cannot use normal jQuery function to show as it requires the
			// display property set to table-row
			$(".meraki_ro_key").css('display', 'table-row');
		}
	});

});


// ADMIN FUNCTIONS

// Called by button click
function get_admins_by_org() {
	// Update the status box
    status_update("Fetching organisations...");
	// Hide the form to prevent people clicking stuff
	$(".meraki_form").hide();
	// Get the key to use
	set_key();
	// Call the general function to get the list of organisations
	// Using the success callback for this operation, and a general error catching callback
    get_organisations(on_get_organisations_success_admins, on_get_organisations_error);
}

// Callback from get_organisations which has succesfully returned data
function on_get_organisations_success_admins(data) {
	// Store the organisations received into the global variable
	orgs = data;
	// Get the number of organisations in the array
	number_of_orgs = orgs.length;
	// Update the status box
	status_update("Found " + number_of_orgs + " organisations - fetching admins...");

	// Get the admins for each organisation
	function getadmin(org) {

        $.ajax({
            dataType: "json",
            url: "api.php",
			method: "post",
			data: {
				action: "get_org_admins",
				orgid: 	data[org].id,
				key: 	key
			},
            success: function (r) {on_get_admin_sucess(r, org);},
            error: function (x, s, e) {on_get_admin_error(e, org);}
        });
	}
	
	var delaygetadmin = _.rateLimit(getadmin, ratelimit);
	
	$.each(data, function(org) {delaygetadmin(org);});
}

// Callback from AJAX call to get organisation admins which has succesfully returned data
function on_get_admin_sucess(administrator, org_index) {
	// Add the new information to the "administrator" object in
	// the global organisation array
    orgs[org_index].administrator = administrator;

	// Mark it as a completed call
	orgs_completed++;

	// Check whether all calls have now returned
		// If they have, print the output
		// Otherwise do nothing as we're still waiting on more data
    if(check_orgs_complete()) {
        print_admins_output();
    }
}

// Callback from AJAX call to get organisation admins which has returned an error
function on_get_admin_error(error, org_index) {
	// Add a new "administrator" object in the global organisation
	// array and mark it with an ERROR value
    orgs[org_index].administrator = [];
	orgs[org_index].administrator[0] = "ERROR";

	// Mark it as a completed call
	orgs_completed++;

	// Check whether all calls have now returned
		// If they have, print the output
		// Otherwise do nothing as we're still waiting on more data
    if(check_orgs_complete()) {
        print_admins_output();
    }
}

// Print the output when the AJAX calls complete
function print_admins_output() {
	// Depending on the page we need to print the output differently
	// The page is defined in a global variable in a script tag
	// on the original HTML page
	if ( page == "orgs_by_admin" ){
		print_admins_output_by_admin();
	}
	else if ( page == "admins_by_org" ) {
		print_admins_output_by_org();
	}
	else if ( page == "add_admin" ) {
		print_orgs_to_add_admin();
	}
	else if ( page == "delete_admin" ) {
		print_select_admin_to_remove();
	}
	else {
		// We define the pages so there shouldn't be any missing
		status_update("Errrrrr - this shouldn't ever be reached - something went very wrong!");
	}
}

// Prints the list of administrators grouped by organisation
function print_admins_output_by_org() {
	status_update('Sorting and generating output...');

	// Sort the organisations by name A -> Z
	sorted = orgs.sort(function(a, b) { return a.name - b.name; });

	// Insert the table into the pre-created div
	$("#meraki_admins_output").html('\
		<table class="meraki_output_table" id="meraki_admins_output_table">\
			<tr>\
				<td class="meraki_output_header_group"><b>Organisation</b></td>\
				<td class="meraki_output_header"><b>Name</b></td>\
				<td class="meraki_output_header"><b>Email Address</b></td>\
				<td class="meraki_output_header"><b>Access Level</b></td>\
			</tr>\
		</table>\
	');

	// Loop over each organisation
	$.each(sorted, function(data) {
		// Check we suceeded in fetching the admins of the network
		if ( sorted[data].administrator[0] != "ERROR" ) {
			// Store the number of admins in this organisation
			number_of_admins = sorted[data].administrator.length;
			// Output the organisation with an appropriate row span along
			// with the first admnistrator
			$("#meraki_admins_output_table").append('\
				<tr>\
					<td rowspan="'+number_of_admins+'" class="meraki_output_group">' + sorted[data].name + '</td>\
					<td>' + sorted[data].administrator[0].name + '</td>\
					<td>' + sorted[data].administrator[0].email + '</td>\
					<td>' + sorted[data].administrator[0].orgAccess + '</td>\
				</tr>\
			');
			// Loop oveer the remainig admins (note i=1 not 0) and output their details
			for (i=1; i<number_of_admins; i++) {
				$("#meraki_admins_output_table").append('\
					<tr>\
						<td>' + sorted[data].administrator[i].name + '</td>\
						<td>' + sorted[data].administrator[i].email + '</td>\
						<td>' + sorted[data].administrator[i].orgAccess + '</td>\
					</tr>\
				');
			}
		}
		else {
			//We failed to get data on this organisation
			$("#meraki_admins_output_table").append('\
				<tr>\
					<td class="meraki_output_group">' + sorted[data].name + '</td>\
					<td>ERROR</td>\
					<td>ERROR</td>\
					<td>ERROR</td>\
				</tr>\
			');
		}
	});
	//Entire function is complete
	status_update("Done...");
}

// Prints the list of organisations grouped by oadministrator
function print_admins_output_by_admin() {
	status_update('Sorting and generating output...');
	
	// Call another function to group organisations by administrator
	// as this is non-trivial and needed elsewhere
	admins = group_orgs_by_admin();

	//TODO: Sort by admin alphabetically
	sorted = admins; //.sort(function(a, b) { return a.name - b.name; });

	// Insert the table into the pre-created div
	$("#meraki_admins_output").html('\
		<table class="meraki_output_table" id="meraki_admins_output_table">\
			<tr>\
				<td class="meraki_output_header_group"><b>Email Address</b></td>\
				<td class="meraki_output_header_group"><b>Name</b></td>\
				<td class="meraki_output_header"><b>Organisation</b></td>\
				<td class="meraki_output_header"><b>Access Level</b></td>\
			</tr>\
		</table>\
	');

	// Loop over each administrator
	$.each(sorted, function(j) {
		// Store the number of organisations available to this admin
		// TODO: Fix variable name but can't number_of_orgs (damn globals!)
		number_of_admins = sorted[j].length;
		// Output the admin with an appropriate row span along
		// with the first organisation
		$("#meraki_admins_output_table").append('\
			<tr>\
				<td rowspan="'+number_of_admins+'" class="meraki_output_group">' + j + '</td>\
				<td rowspan="'+number_of_admins+'" class="meraki_output_group">' + sorted[j].name + '</td>\
				<td>' + sorted[j][0].name + '</td>\
				<td>' + sorted[j][0].orgAccess + '</td>\
			</tr>\
		');
		// Loop oveer the remainig organisations (note i=1 not 0) and output their details
		for (i=1; i<number_of_admins; i++) {
			$("#meraki_admins_output_table").append('\
				<tr>\
					<td>' + sorted[j][i].name + '</td>\
					<td>' + sorted[j][i].orgAccess + '</td>\
				</tr>\
			');
		}
	});
	//Entire function is complete
	status_update("Done...");
}

function print_orgs_to_add_admin() {
	status_update('Sorting and generating output...');
	
	sorted = orgs.sort(function(a, b) { return (a.name < b.name)?-1:((b.name < a.name)?1:0); });
	orgs = sorted;
	
	// Call another function to group organisations by administrator
	// as this is non-trivial and needed elsewhere
	admins = group_orgs_by_admin();
	
	// Check if the admin exists in organisations this key manages
	// If not we can skip the per organisation checks later
	var admin_to_add = $('#meraki_email').val();
	var admin_exists;
	if ( ! (admins[admin_to_add] ) ){
		admin_exists=false;
	}
	else {
		admin_exists = true;
	}
	
	// Add to the HTML page a prompt and the select all box
	$('#meraki_orgsOutput').append('\
		<div class="meraki_row"><p>Please select the organisations to add this user to:</p></div>\
	');
	$('#meraki_orgsOutput').append('<div class="meraki_row" id="meraki_orgs_select_all"></div>');
	$('#meraki_orgs_select_all').append('\
		<div class="meraki_left">\
			<label for="meraki_orgs_select_all_box">\
				Select All\
			</label>\
		</div>\
	');
	$('#meraki_orgs_select_all').append('\
		<div class="meraki_middle">\
			<input type="checkbox" name="select_all" value="select_all" id="meraki_orgs_select_all_box" />\
		</div>\
	');
	
	//  Attach a function to the check all box to be triggered when changed
	$("#meraki_orgs_select_all_box").change(function(event) {

		// Define the checkbox we're working on
		var checkbox = event.target;
		
		// If it's checked, tick all the organisation checkboxes that are not disabled and not already checked
		if (checkbox.checked) {
			$(':checkbox[name="org_checkboxes[]"]:not(:disabled):not(:checked)').each( function () {
				//Note: "this" is the current object in the "each" loop, not the object which raised the event
				this.checked = true;
			});
		}
		// Otherwise, untick all the organisation checkboxes that
		// are not disabled and are already checked
		else {
			$(':checkbox[name="org_checkboxes[]"]:not(:disabled):checked').each( function () {
				//Note: "this" is the current object in the "each" loop,
				// not the object which raised the event
				this.checked = false;
			});
		}
	});

	// Loop over the organisations
	$.each (orgs, function (k) {
		// Add a new row to the table
		$('#meraki_orgsOutput').append('<div class="meraki_row" id="meraki_orgs_'+k+'"></div>');
		// Print the name
		$('#meraki_orgs_'+k).append('\
			<div class="meraki_left">\
				<label for="meraki_org_'+orgs[k].id+'">\
					'+orgs[k].name+'\
				</label>\
			</div>\
		');
		// Print a checkbox with a value and DOM id based on the Meraki id
		$('#meraki_orgs_'+k).append('\
			<div class="meraki_middle">\
				<input type="checkbox" name="org_checkboxes[]" value="'+orgs[k].id+'" id="meraki_org_'+orgs[k].id+'" />\
			</div>\
		');
		
		// Add a status column
		$('#meraki_orgs_'+k).append('<div class="meraki_right" id="meraki_org_output_'+orgs[k].id+'" ></div>');

		// If we were unable to query the admins for the organisation
			// Disable the checkbox
			// Add an error to the output column
			// Set the formatting (CSS class)
		if ( orgs[k].administrator == "ERROR") {
			$('#meraki_org_'+orgs[k].id).attr('disabled','disabled');
			$('#meraki_org_output_'+orgs[k].id).html('Unable to read data');
			$('#meraki_org_output_'+orgs[k].id).addClass('meraki_failure');
		}
		
		// If the admin exists
		if ( admin_exists ) {
			// Loop over administrators organisations
			$.each ( admins[admin_to_add], function (j) {
				//If this organisation is already there
					// Disable the checkbox
					// Add an error to the output column
					// Set the formatting (CSS class)
				if ( admins[admin_to_add][j].id == orgs[k].id ) {
					$('#meraki_org_'+orgs[k].id).attr('disabled','disabled');
					$('#meraki_org_output_'+orgs[k].id).html('Already an admin ('+admins[admin_to_add][j].orgAccess+')');
					$('#meraki_org_output_'+orgs[k].id).addClass('meraki_success');
				}
			});
		}
	});

	// Add a button to submit form
	$('#meraki_orgsOutput').append('\
		<div class="meraki_row">\
			<input type="button" class="meraki_button" name="meraki_go" id="meraki_go" value="Add to Selected Organisations" onclick="add_admin();">\
		</div>\
	');

	// Need to wait for the user to click the button...
	status_update('Waiting for user input...');
}

// Function to add the admin to the selected organisations
function add_admin() {
    status_update("Adding admins...");

	// Hide the button to prevent double submissions
	$("#meraki_go").hide();
	
	// Retrieve values from the form
	var fname = $("#meraki_full_name").val();
	var email = $("#meraki_email").val();
	var orgaccess = $("#meraki_access").val();
	
	// Function to add admins
	function addadmin(org_id) {
		$.ajax({
			dataType: "json",
			url: "api.php",
			method: "post",
			data: {
				action: 	"add_org_admin",
				orgid:		org_id,
				key: 		key,
				fname: 		fname,
				email: 		email,
				orgaccess:	orgaccess
			},
			success: function (r) {on_add_admin_success(r, org_id);},
			error: function (x, s, e) {on_add_admin_error(x, e, org_id);}
		});
	}

	//Create a rate limited function
	var delayaddadmin = _.rateLimit(addadmin, ratelimit);
	
	// Loop over selected check boxes in the org_checkboxes array
	// Don't need to check for enabled as disabled ones are all unticked	
	$(':checkbox[name="org_checkboxes[]"]:checked').each( function () {
		// Get the Meraki organisation id which was stored as the checkbox value
		var org_id = this.value;

		// Update the output column
		$('#meraki_org_output_'+org_id).html('Adding...');

		// Queue an AJAX call to add the admin to the organisation
		delayaddadmin(org_id);
	});
}

// Callback to update output column on success
function on_add_admin_success(r, org_id) {
	$('#meraki_org_output_'+org_id).html('Success')
	$('#meraki_org_output_'+org_id).addClass('meraki_success');
}

// Callback to update output column on error
function on_add_admin_error(x, e, org_id) {
	$('#meraki_org_output_'+org_id).html('HTTP Error: '+e+'<br />Server response (if any): '+x.responseText);
	$('#meraki_org_output_'+org_id).addClass('meraki_failure');
}


function print_select_admin_to_remove() {
	status_update('Sorting and generating output...');
	
	// Call another function to group organisations by administrator
	// as this is non-trivial and needed elsewhere
	admins = group_orgs_by_admin();
	
	// Create list box for admins
	$('#meraki_admins_output').html('<select id="meraki_admin" name="meraki_admin"></select>');
	
	// Loop over admins and add as an option in the list box
	// The index for the admins object is email and this is used by
	// JQuery as the iterator (j) 
	$.each ( admins, function (j) {
		$('#meraki_admin').append('<option value="'+j+'">'+j+' ('+this.name+')</option>');
	});
	
	// Add a button to submit form
	$('#meraki_admins_output').append('\
		<div class="meraki_row">\
			<input type="button" class="meraki_button" name="meraki_next2" id="meraki_next2" value="Next" onclick="get_orgs_for_admin();"\
		</div>\
	');
	status_update('Waiting for user input...');
}

//TODO: Rename this function (print_orgs_to_remove_admin?)
function get_orgs_for_admin() {
	status_update('Sorting and generating output...');
	
	// Hide the previous form to prevent resubmission
	$('#meraki_admins_output').hide();
	
	// Get the admin to remove from the select box
	var admin_to_remove = $('#meraki_admin').val();
	
	sorted = orgs.sort(function(a, b) { return (a.name < b.name)?-1:((b.name < a.name)?1:0); });
	orgs = sorted;

	// Call another function to group organisations by administrator
	// as this is non-trivial and needed elsewhere
	admins = group_orgs_by_admin();
	
	// Add to the HTML page a prompt and the select all box
	$('#meraki_orgs_output').append('\
		<div class="meraki_row"><p>Please select the organisations to remove this user from:</p></div>\
	');
	$('#meraki_orgs_output').append('<div class="meraki_row" id="meraki_orgs_select_all"></div>');
	$('#meraki_orgs_select_all').append('\
		<div class="meraki_left">\
			<label for="meraki_orgs_select_all_box">\
				Select All\
			</label>\
		</div>\
	');
	$('#meraki_orgs_select_all').append('\
		<div class="meraki_middle">\
			<input type="checkbox" name="select_all" value="select_all" id="meraki_orgs_select_all_box" />\
		</div>\
	');
	
	//  Attach a function to the check all box to be triggered when changed
	$("#meraki_orgs_select_all_box").change(function(event) {
		
		// Define the checkbox we're working on
		var checkbox = event.target;
		
		// If it's checked, tick all the organisation checkboxes that are not disabled and not already checked
		if (checkbox.checked) {
			$(':checkbox[name="org_checkboxes[]"]:not(:disabled):not(:checked)').each( function () {
				//Note: "this" is the current object in the "each" loop, not the object which raised the event
				this.checked = true;
			});
		}
		// Otherwise, untick all the organisation checkboxes that
		// are not disabled and are already checked
		else {
			$(':checkbox[name="org_checkboxes[]"]:not(:disabled):checked').each( function () {
				// Note: "this" is the current object in the "each" loop,
				// not the object which raised the event
				this.checked = false;
			});
		}
	});


	// Loop over the organisations
	$.each (orgs, function (k) {
		// Add a new row to the table
		$('#meraki_orgs_output').append('<div class="meraki_row" id="meraki_orgs_'+k+'"></div>');
		// Print the name
		$('#meraki_orgs_'+k).append('\
			<div class="meraki_left">\
				<label for="meraki_org_'+orgs[k].id+'">\
					'+orgs[k].name+'\
				</label>\
			</div>\
		');
		// Print a checkbox with a value and DOM id based on the Meraki id
		$('#meraki_orgs_'+k).append('\
			<div class="meraki_middle">\
				<input type="checkbox" name="org_checkboxes[]" value="'+orgs[k].id+'" id="meraki_org_'+orgs[k].id+'" disabled />\
			</div>\
		');
		
		// Add a status column
		// We assume they're not an admin and set the formatting
		$('#meraki_orgs_'+k).append('<div class="meraki_right" id="meraki_org_output_'+orgs[k].id+'" ></div>');
		$('#meraki_org_output_'+orgs[k].id).html('Not an admin');
		$('#meraki_org_output_'+orgs[k].id).addClass('meraki_success');
		$('#meraki_orgs_'+k).hide();
		
		// If we were unable to query the admins for the organisation
			// Disable the checkbox
			// Add an error to the output column
			// Set the formatting (CSS class)
		if ( orgs[k].administrator == "ERROR") {
			$('#meraki_org_'+orgs[k].id).attr('disabled','disabled');
			$('#meraki_org_output_'+orgs[k].id).html('Unable to read data');
			$('#meraki_org_output_'+orgs[k].id).addClass('meraki_failure');
			$('#meraki_orgs_'+k).hide();
		}
	
		// Loop over administrators organisations
		$.each ( admins[admin_to_remove], function (j) {
			//If this organisation is there
					// Enable the checkbox
					// Clear the output column
					// Remove the formatting (CSS class)
			if ( admins[admin_to_remove][j].id == orgs[k].id ) {
				$('#meraki_org_'+orgs[k].id).removeAttr('disabled');
				$('#meraki_orgs_'+k).css('display', 'table-row');
				$('#meraki_org_'+orgs[k].id).val(orgs[k].id + ':' + admins[admin_to_remove][j].orgAdminId)
				$('#meraki_org_output_'+orgs[k].id).html('');
				$('#meraki_org_output_'+orgs[k].id).removeClass('meraki_success');
			}
		});
	});
	
	// Add a button to submit form
	$('#meraki_orgs_output').append('\
		<div class="meraki_row">\
			<input type="button" class="meraki_button class meraki_button_warning" name="meraki_go" id="meraki_go" value="DELETE from Selected Organisations" onclick="remove_admin();">\
		</div>\
	');
	
	// Need to wait for the user to click the button...
	status_update('Waiting for user input...');
}

// Function to remove the admin from the selected organisations
function remove_admin() {
    status_update("Removing admin...");
	
	// Hide the button to prevent double submissions
	$("#meraki_go").hide();
	
	// Fuction to remove an admin
	function remadmin (org_id, admin_id) {
		$.ajax({
			dataType: "json",
			url: "api.php",
			method: "post",
			data: {
				action: 	"delete_org_admin",
				orgid:		org_id,
				adminid:	admin_id,
				key:		key
			},
			success: function (r) {on_del_admin_success(r, org_id);},
			error: function (x, s, e) {on_del_admin_error(e, org_id);}
		});
	}


	//Create a rate limited function
	var delayremadmin = _.rateLimit(remadmin, ratelimit);

	// Loop over selected check boxes in the org_checkboxes array
	// Don't need to check for enabled as disabled ones are all unticked
	$(':checkbox[name="org_checkboxes[]"]:checked').each( function () {
		// Get the Meraki organisation and admin id which were stored in the checkbox value seperated by :
		var ids = this.value.split(':');
		var org_id = ids[0];
		var admin_id = ids[1];
		
		// Update the output column
		$('#meraki_org_output_'+org_id).html('Removing...');
		
		// Queue an AJAX call to remove the admin from the organisation
		delayremadmin(org_id, admin_id);

	});
}

// Callback to update output column on success
function on_del_admin_success(r, org_id) {
	$('#meraki_org_output_'+org_id).html('Success')
	$('#meraki_org_output_'+org_id).addClass('meraki_success');
}

// Callback to update output column on error
function on_del_admin_error(e, org_id) {
	$('#meraki_org_output_'+org_id).html('Error: '+e);
	$('#meraki_org_output_'+org_id).addClass('meraki_failure');
}


//GET INVENTORY

// Called by button click
function get_inv_orgs() {
	// Update the status box
	status_update("Fetching organisations...");
	// Hide the form to prevent people clicking stuff
	$(".meraki_form").hide();
	// Get the key to use
	set_key();
	// Call the general function to get the list of organisations
	// Using the success callback for this operation, and a general error catching callback
	get_organisations(on_get_organisations_success_inventory, on_get_organisations_error);	
}

// Callback from get_organisations which has succesfully returned data
function on_get_organisations_success_inventory(data) {
	// Update the status box
	status_update('Sorting and generating output...');
	// Store the organisations received into the global variable
	orgs = data;
	// Sort the organisations by name A - Z
	sorted = orgs.sort(function(a, b) { return (a.name < b.name)?-1:((b.name < a.name)?1:0); });
	
	// Create list box for organisations
	$('#meraki_orgs_output').html('<select id="meraki_org" name="meraki_org"></select>');
	
	// Loop over organisations and add as an option in the list box
	$.each ( orgs, function (j) {
		$('#meraki_org').append('<option value="'+this.id+'">'+this.name+'</option>');
	});
	
	// Add a button to submit form
	$('#meraki_orgs_output').append('\
		<div class="meraki_row">\
			<input type="button" class="meraki_button" name="meraki_go" id="meraki_go" value="Get Inventory" onclick="get_inventory();">\
		</div>\
	');
	status_update('Waiting for user input...');
}

// Called by button click
// TODO: Rename this function
function get_inventory() {
	// Update the status box
	status_update("Fetching networks...");
	// Hide the form to prevent people clicking stuff
	$('#meraki_orgs_output').hide();
	// Get the organisation id to use
	var orgid=$('#meraki_org').val();
	// Get the networks in this organisation
	$.ajax({
		dataType: "json",
		url: "api.php",
		method: "post",
		data: {
			action:	"get_org_networks",
			orgid:	orgid,
			key:	key
		},
		success: function (r) {on_get_network_success(r, orgid);},
		error: function (x, s, e) {on_get_network_error(e, orgid);}
	});
}

// Callback from AJAX call to get organisation networks which has succesfully returned data
function on_get_network_success(r, orgid) {
	nets = r;
	number_of_nets = nets.length;
	status_update("Found " + number_of_nets + " networks - fetching device details...");
	
	// Get the devices for each network
    
	function getnetwork (id,orgid,network) {
        $.ajax({
            dataType: "json",
            url: "api.php",
			method: "post",
			data: {
				action:	"get_network_devices",
				orgid:	orgid,
				networkid: id,
				key:	key
			},
            success: function (r) {on_get_devices_success(r, network);},
            error: function (x, s, e) {on_get_devices_error(e, network);}
        });
	}
	var delaygetnetwork = _.rateLimit(getnetwork, ratelimit);
	$.each(r, function(network) {
		delaygetnetwork(this.id,orgid,network);
	});
}

// Callback from AJAX call to get network devices which has succesfully returned data
function on_get_devices_success(devices, net_index) {
	nets[net_index].devices = devices;
	nets_completed++;
    if(check_nets_complete()) {
        print_inventory_output();
	}
}

function on_get_network_error(e, net_index) {
	status_update("Error fetching networks: " + e);
}

function on_get_devices_error(e, net_index) {
	status_update("Error fetching devices: " + e);
	nets[net_index].devices = ["ERROR"];
	nets_completed++;
    if(check_nets_complete()) {
        print_inventory_output();
    }
}

function  print_inventory_output() {
	status_update('Sorting and generating output...');
	
	var csv="Network Name,Network Type,Device Name,Device Serial,Device Model,Device IP,Device MAC\r\n";
	
	sorted = nets; //.sort(function(a, b) { return a.name - b.name; });
	$("#meraki_inventory_output").html('\
		<table class="meraki_output_table" id="meraki_inventory_output_table">\
			<tr>\
				<td class="meraki_output_header_group"><b>Network Name</b></td>\
				<td class="meraki_output_header_group"><b>Network Type</b></td>\
				<td class="meraki_output_header"><b>Device Name</b></td>\
				<td class="meraki_output_header"><b>Device Serial</b></td>\
				<td class="meraki_output_header"><b>Device Model</b></td>\
				<td class="meraki_output_header"><b>Device IP</b></td>\
				<td class="meraki_output_header"><b>Device MAC</b></td>\
			</tr>\
		</table>\
	');
	$.each(sorted, function(j) {
		devices = sorted[j].devices;
		number_of_devices = devices.length;
		if ( number_of_devices > 0 ) {
			$("#meraki_inventory_output_table").append('\
				<tr>\
					<td rowspan="'+number_of_devices+'" class="meraki_output_group">' + this.name + '</td>\
					<td rowspan="'+number_of_devices+'" class="meraki_output_group">' + this.type + '</td>\
					<td>' + devices[0].name + '</td>\
					<td>' + devices[0].serial + '</td>\
					<td>' + devices[0].model + '</td>\
					<td>' + devices[0].lanIp + '</td>\
					<td>' + devices[0].mac + '</td>\
				</tr>\
			');
			csv = csv + ([this.name, this.type, devices[0].name, devices[0].serial, devices[0].model, devices[0].lanIp, devices[0].mac].join()) + "\r\n";
			for (i=1; i<number_of_devices; i++) {
				$("#meraki_inventory_output_table").append('\
					<tr>\
						<td>' + devices[i].name + '</td>\
						<td>' + devices[i].serial + '</td>\
						<td>' + devices[i].model + '</td>\
						<td>' + devices[i].lanIp + '</td>\
						<td>' + devices[i].mac + '</td>\
					</tr>\
				');
				csv = csv + ([sorted[j].name, sorted[j].type, devices[i].name, devices[i].serial, devices[i].model, devices[i].lanIp, devices[i].mac].join()) + "\r\n";
			}
		}
		else {
			$("#meraki_inventory_output_table").append('\
				<tr>\
					<td class="meraki_output_group">' + this.name + '</td>\
					<td class="meraki_output_group">' + this.type + '</td>\
					<td>No devices found</td>\
					<td></td>\
					<td></td>\
					<td></td>\
					<td></td>\
				</tr>\
			');
		}
	});
	$("#meraki_inventory_output").append('<p><br/><br/>Please find below in CSV format:</p>');
	$("#meraki_inventory_output").append('<textarea name="meraki_inventory_csv_output" id="meraki_inventory_csv_output" style="width:100%" rows="50" ></textarea>');
	$('#meraki_inventory_csv_output').text(csv);
	status_update("Done...");
}

function check_nets_complete() {
    if( nets_completed != number_of_nets) { 
		status_update("Retrieved data for " + nets_completed + " / " + number_of_nets + " networks - waiting for more data...");
        return false;
    }
    return true;
}

//GET LICENCES

function get_licence_state() {
	
	status_update("Fetching organisations...");
	$(".meraki_form").hide();
	set_key();
	get_organisations(on_get_organisations_success_licences, on_get_organisations_error);	
}


function on_get_organisations_success_licences(data) {
	orgs = data;
	number_of_orgs = orgs.length;
	status_update("Found " + number_of_orgs + " organisations - fetching licence states...");

	function getlic (org) {
        $.ajax({
            dataType: "json",
            url: "api.php",
			method: "post",
			data: {
				action:	"get_org_licences",
				orgid:	data[org].id,
				key:	key
			},
            success: function (r) {on_get_licence_sucess(r, org);},
            error: function (x, s, e) {on_get_licence_error(e, org);}
        });
	}
	var delaygetlic = _.rateLimit(getlic, ratelimit);

    $.each(data, function(org) {delaygetlic(org)});
}

function on_get_licence_sucess(lic, org_index) {
	orgs[org_index].licStatus = lic['status'];
	orgs[org_index].licExpirationDate = Date.parse(lic['expirationDate']);
	orgs[org_index].licLicensedDeviceCounts = lic['licensedDeviceCounts'];	
	orgs_completed++;
    if(check_orgs_complete()) {
        print_licence_output();
    }
}

function on_get_licence_error(error, org_index) {
	orgs[org_index].licStatus = "ERROR";
	orgs[org_index].licExpirationDate = Date.parse(0);
	orgs[org_index].licLicensedDeviceCounts = "ERROR";
	orgs_completed++;
    if(check_orgs_complete()) {
        print_licence_output();
    }
}

function print_licence_output() {
	status_update('Sorting and generating output...');
	sorted = orgs.sort(function(a, b) { return a.licExpirationDate - b.licExpirationDate; });
	$("#meraki_licence_output").html('\
		<table id="merkai_licence_output_table">\
			<tr>\
				<td class="meraki_output_header_group"><b>Organisation</b></td>\
				<td class="meraki_output_header_group"><b>Status</b></td>\
				<td class="meraki_output_header_group"><b>Expiration Date</b></td>\
				<td class="meraki_output_header_group"><b>Device Type</b></td>\
				<td class="meraki_output_header_group"><b>Device Count</b></td>\
			</tr>\
		</table>\
	');
	$.each(sorted, function(data) {
		d = new Date(sorted[data].licExpirationDate);
		n = d.toDateString();
		licenced_devices = dump_licenced_devices(sorted[data].licLicensedDeviceCounts);
		number_of_types=licenced_devices.length;
		var status_class = '';
		switch (sorted[data].licStatus) {
			case "ERROR":
			case "Expired":
			case "License Required":
				status_class = 'meraki_failure';
				break;
			case "License Expires Soon":
				status_class = 'meraki_warning';
				break;
			case "OK":
				status_class = 'meraki_success';
				break;
			default:
				break;
		}
		
		$("#merkai_licence_output_table").append('\
			<tr>\
				<td rowspan="'+number_of_types+'" class="meraki_output_group">' + sorted[data].name + '</td>\
				<td rowspan="'+number_of_types+'" class="meraki_output_group ' + status_class + '">' + sorted[data].licStatus + '</td>\
				<td rowspan="'+number_of_types+'" class="meraki_output_group">' + n + '</td>\
				<td class="meraki_output_group">'+ licenced_devices[0].type + '</td>\
				<td class="meraki_output_group">'+ licenced_devices[0].count + '</td>\
			</tr>\
		');	
		for (i=1; i<number_of_types; i++) {
			$("#merkai_licence_output_table").append('\
				<tr>\
					<td class="meraki_output_group">' + licenced_devices[i].type + '</td>\
					<td class="meraki_output_group">' + licenced_devices[i].count + '</td>\
				</tr>\
			');
		}
	});
	status_update("Done...");
}

function dump_licenced_devices(data) {
	var i = 0;
	var list = [];
	if (data != 'ERROR'){
		for (type in data) {
			list[i] = { type: type, count: data[type] };
			i++;
		}
	}
	else {
		list[i] = {type:'ERROR', count:'ERROR'};
	}
	return list;
}



//GENERAL FUNCTIONS

function check_orgs_complete() {
    if( orgs_completed != number_of_orgs) { 
		status_update("Retrieved data for " + orgs_completed + " / " + number_of_orgs + " organisations - waiting for more data...");
        return false;
    }
    return true;
}


function do_this_when_all_loops_are_done() {
	status_update("Done...");
}

function get_organisations(callback_success, callback_error) {
        $.ajax({
            dataType: "json",
            url: "api.php",
			method: "post",
			data: {
				action:	"get_orgs",
				key:	key
			},
            success: function(r) {callback_success(r);},
            error: function(x, s, e) {callback_error(e);}
        });     
}

function on_get_organisations_error (jqXHR, textStatus, errorThrown) {
	status_update("Error..." + errorThrown);
}

function group_orgs_by_admin () {
	var admins = {};
	$.each (orgs, function(j) {
		$.each (orgs[j].administrator, function (k) {
			if (orgs[j].administrator[k] != "ERROR") {
				var current_admin = orgs[j].administrator[k];
				if (!admins[current_admin.email]) {

					admins[current_admin.email]=[];
					
					admins[current_admin.email].name = current_admin.name;
				}

				var next_org = admins[current_admin.email].length;

				admins[current_admin.email][next_org]= { id: 			orgs[j].id,
														 name:			orgs[j].name,
														 orgAdminId: 	current_admin.id,
														orgAccess: 	current_admin.orgAccess
														};
				
			}
			
			
		});
	});
	return admins;
}

function status_update(t) {
    $("#meraki_status").html("<pre>Current status: " + t + "</pre>");
	return 1;
}

function set_key() {
 	if (!($("#meraki_ro_key").is(':checked'))) {
		key = $("#meraki_api_key").val();
	}
	else{
		key = "rokey";
	}
}
