#include "NetFlowDataTemplateCache.h"

NetFlowDataTemplateCache::NetFlowDataTemplateCache(void) {
}

bool NetFlowDataTemplateCache::AddDataTemplate (unsigned short templateID, NetFlowDataTemplate* dataTemplate) {
	NetFlowDataTemplate *test;
	printf("    -> Adding DataTemplate ID %d.\n", templateID);
	try {
		printf("      -> Trying to fetch %d.\n", templateID);
		test = _Cache.at(templateID);
	}
	catch (const std::out_of_range oor) {
		//Out of range --> Not in Cache - Great!
		printf("      -> Not found - adding.\n");
		_Cache[templateID] = dataTemplate;
		return true;
	}
	//Uh-oh - this ID is already in the cache
	printf("      -> Already in the cache - fail.\n", templateID);
	return 0;
}

bool NetFlowDataTemplateCache::ExistsDataTemplate (unsigned short templateID) {
	NetFlowDataTemplate *test;
	printf("    -> Checking for DataTemplate ID %d.\n", templateID);
	try {
		printf("      -> Trying to fetch %d.\n", templateID);
		test = _Cache.at(templateID);
	}
	catch (const std::out_of_range oor) {
		printf("      -> Not found.\n");
		//Out of range --> Not in Cache
		return 0;
	}
	printf("      -> Found.\n");
	return 1;
}

NetFlowDataTemplate* NetFlowDataTemplateCache::GetDataTemplate (unsigned short templateID) {
	NetFlowDataTemplate *dataTemplate;
	printf("    -> Getting DataTemplate ID %d.\n", templateID);
	try {
		printf("      -> Trying to fetch %d.\n", templateID);
		dataTemplate = _Cache.at(templateID);
	}
	catch (const std::out_of_range oor) {
		printf("      -> Not found.\n");
		//Out of range --> Not in Cache
		return 0;
	}
	printf("      -> Found.\n");
	return dataTemplate;
}

NetFlowDataTemplate* NetFlowDataTemplateCache::DeleteDataTemplate (unsigned short templateID) {
	NetFlowDataTemplate *dataTemplate;
	printf("    -> Deleting DataTemplate ID %d.\n", templateID);
	try {
		printf("      -> Trying to fetch %d.\n", templateID);
		dataTemplate = _Cache.at(templateID);
		_Cache.erase(templateID);
	}
	catch (const std::out_of_range oor) {
		printf("      -> Not found.\n");
		//Out of range --> Not in Cache
		return 0;
	}
	printf("      -> Deleted.\n");
	return dataTemplate;
}
