#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include "NetFlowDataTemplateCache.h"
#include "FlowSet.h"

#ifndef NETFLOW9PROCESSOR
#define NETFLOW9PROCESSOR
class NetFlow9Processor{


	public:

		NetFlow9Processor(struct sockaddr *remaddr, socklen_t *addrlen);
		int ProcessPacket(unsigned char b[], int l, FlowSet* processedFlowSet);


	private:

		NetFlowDataTemplateCache *dataTemplateCache;
		char remoteIPStr[];
		unsigned char remoteIPBytes[];
//		NetFlowDataTemplate::DataTemplateItem_t *strtest;

		unsigned int ByteTouInt32(unsigned char b[], int base);
		unsigned short ByteTouInt16(unsigned char b[], int base);
		void processDataFlowSet(unsigned char b[], int nextIndex, unsigned short flowSetID, unsigned short flowSetLength);
		void processTemplateFlowSet(unsigned char b[], int nextIndex, unsigned short flowSetLength);


};

#endif
