#include "NetFlowDataTemplateCache.h"

NetFlowDataTemplateCache::NetFlowDataTemplateCache(void) {
}

bool NetFlowDataTemplateCache::AddDataTemplate (unsigned short id, NetFlowDataTemplate* dataTemplate) {
	NetFlowDataTemplate *test;
	printf("    -> Adding DataTemplate ID %d.\n", id);
	try {
		printf("      -> Trying to fetch %d.\n", id);
		test = Cache.at(id);
	}
	catch (const std::out_of_range oor) {
		//Out of range --> Not in Cache - Great!
		printf("      -> Not found - adding.\n");
		Cache[id] = dataTemplate;
		return true;
	}
	//Uh-oh - this ID is already in the cache
	printf("      -> Already in the cache - fail.\n", id);
	return 0;
}

bool NetFlowDataTemplateCache::ExistsDataTemplate (unsigned short id) {
	NetFlowDataTemplate *test;
	printf("    -> Checking for DataTemplate ID %d.\n", id);
	try {
		printf("      -> Trying to fetch %d.\n", id);
		test = Cache.at(id);
	}
	catch (const std::out_of_range oor) {
		printf("      -> Not found.\n");
		//Out of range --> Not in Cache
		return 0;
	}
	printf("      -> Found.\n");
	return 1;
}

NetFlowDataTemplate* NetFlowDataTemplateCache::GetDataTemplate (unsigned short id) {
	NetFlowDataTemplate *dataTemplate;
	printf("    -> Getting DataTemplate ID %d.\n", id);
	try {
		printf("      -> Trying to fetch %d.\n", id);
		dataTemplate = Cache.at(id);
	}
	catch (const std::out_of_range oor) {
		printf("      -> Not found.\n");
		//Out of range --> Not in Cache
		return 0;
	}
	printf("      -> Found.\n");
	return dataTemplate;
}

NetFlowDataTemplate* NetFlowDataTemplateCache::DeleteDataTemplate (unsigned short id) {
	NetFlowDataTemplate *dataTemplate;
	printf("    -> Deleting DataTemplate ID %d.\n", id);
	try {
		printf("      -> Trying to fetch %d.\n", id);
		dataTemplate = Cache.at(id);
		Cache.erase(id);
	}
	catch (const std::out_of_range oor) {
		printf("      -> Not found.\n");
		//Out of range --> Not in Cache
		return 0;
	}
	printf("      -> Deleted.\n");
	return dataTemplate;
}
