#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include "NetFlowDataTemplateCache.h"
#include "FlowSet.h"

#ifndef NETFLOW9PROCESSOR
#define NETFLOW9PROCESSOR
class NetFlow9Processor{


	public:

		NetFlow9Processor(struct sockaddr *remoteAddress, socklen_t *addressLength);
		FlowSet* ProcessPacket(unsigned char buffer[], int bufferLength);


	protected:

		NetFlowDataTemplateCache *dataTemplateCache;
		char remoteIPStr[INET6_ADDRSTRLEN];
		unsigned char remoteIPBytes[16];
		std::string name;
//		NetFlowDataTemplate::DataTemplateItem_t *strtest;

		unsigned int ByteTouInt32(unsigned char bytes[], int base);
		unsigned short ByteTouInt16(unsigned char bytes[], int base);
		FlowSet* processDataFlowSet(unsigned char buffer[], int nextIndex, unsigned short flowSetID, unsigned short flowSetLength, char strRemoteIP[]);
		void processTemplateFlowSet(unsigned char buffer[], int nextIndex, unsigned short flowSetLength);


};

#endif
