#include "NetFlow9Processor.h"

unsigned int NetFlow9Processor::ByteTouInt32(unsigned char bytes[], int base) {
	//TODO: Check for out of range muppets
	//TODO: Endianess issues?
	return (bytes[base] << 24) + (bytes[base+1] << 16) + (bytes[base+2] << 8) + bytes[base+3];
}

unsigned short NetFlow9Processor::ByteTouInt16(unsigned char bytes[], int base) {
	//TODO: Check for out of range muppets
	//TODO: Endianess issues?
	return (bytes[base] << 8) + bytes[base+1];
}


NetFlow9Processor::NetFlow9Processor(struct sockaddr *remoteAddress, socklen_t *addressLength) {
	dataTemplateCache = new NetFlowDataTemplateCache();
	switch (remoteAddress->sa_family) {
		case AF_INET:
			//set IP
			break;
		case AF_INET6:
			//set IP
			break;
		default:
			//uhoh
			break;
	}
	
}

int NetFlow9Processor::ProcessPacket(unsigned char buffer[], int bufferLength, FlowSet* processedFlowSet) {

	int nextIndex = 0;					// Next byte in the buffer
	int version = 0;					// NetFlow version
	int count = 0;						// Records in the packet
	unsigned short flowSetID = 0;		// ID of the current FlowSet
	unsigned short flowSetLength = 0;	// Bytes in the current FlowSet
	unsigned int uptime = 0;			// Router uptime in miliseconds
	unsigned int packetTime = 0;		// Time sent by router (Unix seconds)
	unsigned int sequenceID = 0;		// Incremented by one for each packet sent
	unsigned int sourceID = 0;			// Locally significant source ID

	if ( bufferLength < 24) {
		//Packet is too short to contain a header
		return 254;
	}
	
	//First 2 bytes (0 and 1) are the version
	version = (buffer[0] << 8 ) + buffer [1];
	if (version != 9) {
			//Not a NetFlow v9 packet
			return 253;
	}

	//Bytes 2 and 3 are the count of records in the packet
	count = (buffer[2] << 8 ) + buffer [3];

	if (count < 1) {
			//Not a NetFlow v9 packet
			return 252;
	}

	nextIndex = 4;
	uptime = ByteTouInt32(buffer,nextIndex);
	nextIndex += 4;
	packetTime = ByteTouInt32(buffer,nextIndex);
	nextIndex += 4;
	sequenceID = ByteTouInt32(buffer,nextIndex);
	nextIndex += 4;
	sourceID = ByteTouInt32(buffer,nextIndex);
	nextIndex += 4;

	do {
		flowSetID = ByteTouInt16(buffer,nextIndex);
		flowSetLength = ByteTouInt16(buffer,nextIndex+2);
		if (nextIndex + flowSetLength > bufferLength) {
			//Invalid/unsupported packet
			return 251;
		}
		if (flowSetID > 255) {
			//DATA FlowSet
			printf("  -> Found data flowSetID %d, length %d.\n", flowSetID, flowSetLength);
			processDataFlowSet(buffer,nextIndex,flowSetID,flowSetLength);
		}
		else if (flowSetID == 0) {
			//TEMPLATE FlowSet
			printf("  -> Found template flowSetID %d, length %d.\n", flowSetID, flowSetLength);
			processTemplateFlowSet(buffer,nextIndex,flowSetLength);
		}
		else if (flowSetID == 1) {
			//OPTIONS FlowSet
			printf("  -> Found options flowSetID %d, length %d.\n", flowSetID, flowSetLength);
		}
		else {
			//Invalid/unsupported packet
			return 250;
		}
		nextIndex += flowSetLength;
	}
	while ( nextIndex < bufferLength);

	return sequenceID;
}

void NetFlow9Processor::processDataFlowSet(unsigned char buffer[], int startIndex, unsigned short flowSetID, unsigned short flowSetLength) {
	int nextIndex = startIndex + 4;             // Next place to look (skip 4 header bytes already parsed)
	int endIndex = startIndex + flowSetLength ; // End the loop at the end of the template
	NetFlowDataTemplate *dataTemplate;          // Data Template object
	NetFlowDataTemplate::Field_t field;
	int count = 0;

	do {
		
		dataTemplate = dataTemplateCache->GetDataTemplate(flowSetID);
		if (!dataTemplate) {
			printf("  -> Template ID %d doesn't exist in the cache...  skipping\n", flowSetID);
			return;
		}
		printf("  -> Parsing record %d.\n", count);
		for (std::list<NetFlowDataTemplate::Field_t>::iterator it=dataTemplate->Fields.begin(); it != dataTemplate->Fields.end(); ++it) {
			field = *it;
			printf("    -> Code: %d, length: %d\n", field.code, field.length);
			nextIndex += field.length;
		}
		count++;
	}
	while ( nextIndex < endIndex );
}
void NetFlow9Processor::processTemplateFlowSet(unsigned char buffer[], int startIndex, unsigned short flowSetLength) {

	int nextIndex = startIndex + 4;				// Next place to look (skip 4 header bytes already parsed)
	int endIndex = startIndex + flowSetLength ; // End the loop at the end of the template
	unsigned short count = 0;					// Count of fields to extract
	unsigned short id = 0;						// ID the template applies to
	NetFlowDataTemplate *dataTemplate;			// Data Template object
	NetFlowDataTemplate *existingDataTemplate;	// Data Template object if it already exists
	NetFlowDataTemplate::Field_t field;

	do {

		//Lets get the Template ID and the count of fields
		id = ByteTouInt16(buffer,nextIndex);
		count = ByteTouInt16(buffer,nextIndex+2);

		printf("  -> Template ID %d\n", id);
	
		//Increment nextIndex to skip the 4 bytes of the header already parsed
		nextIndex += 4;

		dataTemplate = new NetFlowDataTemplate(id, count);

		int i;

		for (i=0; i < count; i++) {
			field.code = ByteTouInt16(buffer,nextIndex);
			field.length = ByteTouInt16(buffer,nextIndex+2);
			printf("    -> Field %d. Field Code %d, length %d\n", i, field.code, field.length );
			dataTemplate->Fields.push_back( field );
			nextIndex += 4;
		}

		//Check if ID is in cache
		if ( dataTemplateCache->ExistsDataTemplate(id) ) {
			//Yes --> Update
			printf("  -> Template ID %d in cache.\n", id);
			existingDataTemplate = dataTemplateCache->DeleteDataTemplate(id);
			delete existingDataTemplate;
			if ( dataTemplateCache->AddDataTemplate(id, dataTemplate) ) {
				printf("  -> Template ID %d updated.\n", id);
			}
			else {
				printf("  -> ERROR: Failed to update Template ID %d.\n", id);
			}
		}
		else {
			//No --> Add
			if ( dataTemplateCache->AddDataTemplate(id, dataTemplate) ) {
				printf("  -> Template ID %d added.\n", id);
			}
			else {
				printf("  -> ERROR: Failed to add Template ID %d.\n", id);
			}
		}


	}
	while ( nextIndex < endIndex );

}
