#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include "port.h"
#include "NetFlow9Processor.h"
#include "FlowSet.h"

//TODO: Base this on the MTU of the interface
#define BUFSIZE 2048	/* Assuming we're using a 1500MTU */

int main(int argc, char **argv) {

	struct sockaddr_in localAddress;				/* Address to bind */
	struct sockaddr_in remoteAddress;				/* Remote address */
	socklen_t addressLength = sizeof(remoteAddress);/* Length of addresses */
	int bytesReceived;								/* Number of bytes received */
	int fd;											/* Our socket */
	unsigned char buffer[BUFSIZE];					/* Receive buffer */
	NetFlow9Processor *NetFlow9;					/* Processor do the hard work */
	int retval;										/* Return value from processor */
	FlowSet *processedFlowSet;						/* Returned flowset after processing */


	//Create a UDP socket - currently IPv4 only
	//TODO: Support IPv6

	if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		perror("cannot create socket\n");
		return 0;
	}

	//Bind the socket to any valid IP address and the port defined in the header
	//TODO: Move to CLI args for interfaces/IPs/ports

	memset((char *)&localAddress, 0, sizeof(localAddress));
	localAddress.sin_family = AF_INET;
	localAddress.sin_addr.s_addr = htonl(INADDR_ANY);
	localAddress.sin_port = htons(SERVICE_PORT);

	if (bind(fd, (struct sockaddr *)&localAddress, sizeof(localAddress)) < 0) {
		perror("bind failed");
		return 0;
	}

	remoteAddress.sin_family = AF_INET;
	//TODO: Massive fudge for testing - get real IP and make array of Processors
	//TODO: One per IP.  Also support IPv6
	inet_pton(AF_INET, "8.8.8.8", &(remoteAddress.sin_addr));
	NetFlow9 = new NetFlow9Processor((struct sockaddr *)&remoteAddress, &addressLength);

	//NetFlow is very simple, so we can simply loop over all packets
	//received.
	for (;;) {
//		printf("waiting on port %d\n", SERVICE_PORT);
		bytesReceived = recvfrom(fd, buffer, BUFSIZE, 0, (struct sockaddr *)&remoteAddress, &addressLength);

		if (remoteAddress.sin_family != AF_INET) {
			continue; //Ooops something wrong with this packet
		}

//		printf("received %d bytes\n", bytesReceived);
		if (bytesReceived > 2) {
			int version = (buffer[0] << 8 ) + buffer [1];


			switch (version) {
				case 9:
					//NFv9
//					printf("Len: %d...  Running NetFlow9Packet Processor\n", bytesReceived);
					retval = NetFlow9->ProcessPacket(buffer,bytesReceived,processedFlowSet);
					if ( processedFlowSet == 0 ) {
						printf("Error in NF9Processor - invalid pointer\n");
					}
					break;
				default:
					return 254;
			}

			printf("PacketProcessor returned %d\n",processedFlowSet);
		}
	}
}
