#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include "port.h"
#include "NetFlow9Processor.h"

#define BUFSIZE 2048

int
main(int argc, char **argv)
{
	struct sockaddr_in myaddr;			/* our address */
	struct sockaddr_in remaddr;			/* remote address */
	socklen_t addrlen = sizeof(remaddr);/* length of addresses */
	int recvlen;						/* # bytes received */
	int fd;								/* our socket */
	unsigned char buf[BUFSIZE];			/* receive buffer */
	NetFlow9Processor *NetFlow9;		/* Processor do the hard work */
	int retval;							/*Return value from processor */

	NetFlow9 = new NetFlow9Processor();

	//Create a UDP socket - currently IPv4 only
	//TODO: Support IPv6

	if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		perror("cannot create socket\n");
		return 0;
	}

	//Bind the socket to any valid IP address and the port defined in the header
	//TODO: Move to CLI args for interfaces/IPs/ports

	memset((char *)&myaddr, 0, sizeof(myaddr));
	myaddr.sin_family = AF_INET;
	myaddr.sin_addr.s_addr = htonl(INADDR_ANY);
	myaddr.sin_port = htons(SERVICE_PORT);

	if (bind(fd, (struct sockaddr *)&myaddr, sizeof(myaddr)) < 0) {
		perror("bind failed");
		return 0;
	}

	//NetFlow is very simple, so we can simply loop over all packets
	//received.
	for (;;) {
		printf("waiting on port %d\n", SERVICE_PORT);
		recvlen = recvfrom(fd, buf, BUFSIZE, 0, (struct sockaddr *)&remaddr, &addrlen);
		printf("received %d bytes\n", recvlen);
		if (recvlen > 2) {
			int version = (buf[0] << 8 ) + buf [1];
			switch (version) {
				case 9:
					//NFv9
					printf("Len: %d...  Running NetFlow9Packet Processor\n", recvlen);
					retval = NetFlow9->ProcessPacket(buf,recvlen);
					break;
				default:
					return 254;
			}

			printf("PacketProcessor returned %d\n",retval);
		}
	}
}
