#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "IPFixProcessor.h"

unsigned int IPFixProcessor::ByteTouInt32(unsigned char b[], int base) {
	//TODO: Check for out of range muppets
	//TODO: Endianess issues?
	return (b[base] << 24) + (b[base+1] << 16) + (b[base+2] << 8) + b[base+3];
}

unsigned short IPFixProcessor::ByteTouInt16(unsigned char b[], int base) {
	//TODO: Check for out of range muppets
	//TODO: Endianess issues?
	return (b[base] << 8) + b[base+1];
}


IPFixProcessor::IPFixProcessor(void) {
	dataTemplateCache = new NetFlowDataTemplateCache();
}

int IPFixProcessor::ProcessPacket(unsigned char b[], int l) {

	int nextIndex = 0;					// Next byte in the buffer
	int version = 0;					// NetFlow version
	int count = 0;						// Records in the packet
	unsigned short flowSetID = 0;		// ID of the current FlowSet
	unsigned short flowSetLength = 0;	// Bytes in the current FlowSet
	unsigned int uptime = 0;			// Router uptime in miliseconds
	unsigned int packetTime = 0;		// Time sent by router (Unix seconds)
	unsigned int sequenceID = 0;		// Incremented by one for each packet sent
	unsigned int sourceID = 0;			// Locally significant source ID

	if ( l < 24) {
		//Packet is too short to contain a header
		return 254;
	}
	
	//First 2 bytes (0 and 1) are the version
	version = (b[0] << 8 ) + b [1];
	if (version != 9) {
			//Not a NetFlow v9 packet
			return 253;
	}

	//Bytes 2 and 3 are the count of records in the packet
	count = (b[2] << 8 ) + b [3];

	if (count < 1) {
			//Not a NetFlow v9 packet
			return 252;
	}

	nextIndex = 4;
	uptime = ByteTouInt32(b,nextIndex);
	nextIndex += 4;
	packetTime = ByteTouInt32(b,nextIndex);
	nextIndex += 4;
	sequenceID = ByteTouInt32(b,nextIndex);
	nextIndex += 4;
	sourceID = ByteTouInt32(b,nextIndex);
	nextIndex += 4;

	do {
		flowSetID = ByteTouInt16(b,nextIndex);
		flowSetLength = ByteTouInt16(b,nextIndex+2);
		if (nextIndex + flowSetLength > l) {
			//Invalid/unsupported packet
			return 251;
		}
		if (flowSetID > 255) {
			//DATA FlowSet
			//printf("  -> Found data flowSetID %d, length %d.\n", flowSetID, flowSetLength);
			//processDataFlowSet(b,nextIndex,flowSetID,flowSetLength);
		}
		else if (flowSetID == 0) {
			//TEMPLATE FlowSet
			printf("  -> Found template flowSetID %d, length %d.\n", flowSetID, flowSetLength);
			processTemplateFlowSet(b,nextIndex,flowSetLength);
		}
		else if (flowSetID == 1) {
			//OPTIONS FlowSet
			printf("  -> Found options flowSetID %d, length %d.\n", flowSetID, flowSetLength);
		}
		else {
			//Invalid/unsupported packet
			return 250;
		}
		nextIndex += flowSetLength;
	}
	while ( nextIndex < l);

	return sequenceID;
}

void IPFixProcessor::processDataFlowSet(unsigned char b[], int nextIndex, unsigned short flowSetID, unsigned short flowSetLength) {

}
void IPFixProcessor::processTemplateFlowSet(unsigned char b[], int startIndex, unsigned short flowSetLength) {

	int nextIndex = startIndex + 4;				// Next place to look (skip 4 header bytes already parsed)
	int endIndex = startIndex + flowSetLength ; // End the loop at the end of the template
	unsigned short count = 0;					// Count of fields to extract
	unsigned short id = 0;						// ID the template applies to	

	do {

		//Lets get the Template ID and the count of fields
		id = ByteTouInt16(b,nextIndex);
		count = ByteTouInt16(b,nextIndex+2);

		printf("  -> Template ID %d\n", id);
	
		//Increment nextIndex to skip the 4 bytes of the header already parsed
		nextIndex += 4;

		int i;

		for (i=0; i < count; i++) {
			unsigned short field = ByteTouInt16(b,nextIndex);
			unsigned short length = ByteTouInt16(b,nextIndex+2);
			printf("    -> Field %d. Field Code %d, length %d\n", i, field, length );
			nextIndex += 4;
		}
	}
	while ( nextIndex < endIndex );

}
