#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include "NetFlow9Processor.h"
#include "FlowSet.h"
#include "Config.h"

//TODO: Base this on the MTU of the interface
#define BUFSIZE 2048	/* Assuming we're using a 1500MTU */

int main(int argc, char **argv, char* envp[]) {

	struct sockaddr_in localAddress;				/* Address to bind */
	struct sockaddr_in remoteAddress;				/* Remote address to listen for */
	struct sockaddr_in remotePacketAddress;			/* Remote packet address */
	socklen_t addressLength = sizeof(remoteAddress);/* Length of addresses */
	int bytesReceived;								/* Number of bytes received */
	int fd;											/* Our socket */
	unsigned char buffer[BUFSIZE];					/* Receive buffer */
	NetFlow9Processor *NetFlow9;					/* Processor do the hard work */
	int retval;										/* Return value from processor */
	FlowSet *processedFlowSet;						/* Returned flowset after processing */
	string filename = "/home/ian/projects/NetSlow/netslow.conf";	/* Configuration file - TODO: Add to CLI Arguments */
	std::string name;

	Config *config = new Config(filename, envp);

	//TODO: Error/syntax checking

	//Create a UDP socket - currently IPv4 only
	//TODO: Support IPv6

	if ((fd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		perror("cannot create socket\n");
		return 0;
	}

	//Bind the socket to IP address and port defined in the config file
	//TODO: Also support IPv6
	memset((char *)&localAddress, 0, sizeof(localAddress));
	localAddress.sin_family = AF_INET;
	inet_pton(AF_INET, config->pString("bind_ip").c_str(), &(localAddress.sin_addr));
	localAddress.sin_port = htons(config->pInt("bind_port"));

	if (bind(fd, (struct sockaddr *)&localAddress, sizeof(localAddress)) < 0) {
		perror("bind failed");
		return 0;
	}


	if (config->pBool("single_router")) {

		remoteAddress.sin_family = AF_INET;
		//TODO: Support IPv6
		inet_pton(AF_INET, config->group("router1")->pString("ip").c_str(), &(remoteAddress.sin_addr));
		NetFlow9 = new NetFlow9Processor((struct sockaddr *)&remoteAddress, &addressLength);
		
		if (config->group("router1")->pString("name").c_str()) {
			//TODO: Assign to processor
			name = config->group("router1")->pString("name");
		}

		//NetFlow is very simple, so we can simply loop over all packets
		//received.
		for (;;) {
			//		printf("waiting on port %d\n", SERVICE_PORT);
			bytesReceived = recvfrom(fd, buffer, BUFSIZE, 0, (struct sockaddr *)&remotePacketAddress, &addressLength);

			if (remotePacketAddress.sin_family != AF_INET || remotePacketAddress.sin_addr.s_addr != remoteAddress.sin_addr.s_addr) {
				continue; //Ooops something wrong with this packet or it's not from the correct router
			}

			//		printf("received %d bytes\n", bytesReceived);
			if (bytesReceived > 2) {
				int version = (buffer[0] << 8) + buffer[1];


				switch (version) {
				case 9:
					//NFv9
//					printf("Len: %d...  Running NetFlow9Packet Processor\n", bytesReceived);
					processedFlowSet = NetFlow9->ProcessPacket(buffer, bytesReceived);
					if (processedFlowSet == nullptr) {
						printf("Possible error in NF9Processor - invalid pointer\n");
					}
					else {
						printf("PacketProcessor returned %d flow set records\n", processedFlowSet->GetCount());
						printf("FSR 0, record 6, code %x, length %d, value: ", processedFlowSet->GetRecord(0)->GetRecord(6).code, processedFlowSet->GetRecord(0)->GetRecord(6).length);
						for (int i = 0; i < processedFlowSet->GetRecord(0)->GetRecord(6).length; i++) { printf("%02X", processedFlowSet->GetRecord(0)->GetRecord(6).data[i]); }
						printf("\n");
						delete processedFlowSet;
					}
					break;
				default:
					return 254;
				}

			}
		}
	}
}
