<?php require 'include.php'; 
$page_name = "Secure Password Distribution";
$page_header = preg_replace ( '/PAGE_NAME/', $page_name, $page_header );
echo ( $page_header );

if ( !( isset ( $_POST[ 'reference' ] ) ) || $_POST[ 'reference' ] == '' ) { ?>
	<h3>Welcome back <?php echo ( $_SERVER[ 'REMOTE_USER' ] ); ?></h3>
	<form method="post">
		<p>SDP Reference: <input type="text" name="reference" id="reference" /></p>
		<p>Password to store: <input type="password" name="passwd" id="passwd" /></p>
		<p><input type="submit" name="Create" value="Create" /></p>
	</form>
	<p>Previous passwords issued:</p>
	<table>
		<tr>
			<td><b>SDP Reference</b></td>
			<td><b>Date Created</b></td>
			<td><b>Date Deleted</b></td>
			<td><b>Reason Deleted</b></td>
			<td><b>Failed Attempts</b></td>
		</tr>
		<?php get_history_rows ( $_SERVER[ 'REMOTE_USER' ] ); ?>
	</table>
<?php }
else {
	$salt = mcrypt_create_iv ( 16, MCRYPT_RAND );
	$hash = md5 ( mcrypt_create_iv ( 128, MCRYPT_RAND ) );
	$id = substr ( md5 ( mcrypt_create_iv ( 128, MCRYPT_RAND ) ), 4, 6 );
	
	//CheckID is valid against db
	
	$reference = $_POST[ 'reference' ];
	$password = $_POST[ 'passwd' ];
	$username = $_SERVER[ 'REMOTE_USER' ];
	
	$iv = mcrypt_create_iv ( 32, MCRYPT_RAND );
	
	//This needs to be a more secure hash - maybe run 100000 cycles? or move to sCrypt?
	$key = pack ( 'H*', hash ( 'sha256', $salt . $reference . $hash ) );
	
	$enc = encrypt ( $password, $key, $iv );
	
	//This needs to be a more secure hash - maybe run 100000 cycles? or move to sCrypt?
	$check = pack ( 'H*', hash ( 'sha256', $enc . $hash ) );
	
	
	create_password ( $id, $reference, date( "Y-m-d H:i:s" ), $username, $salt, $iv, $check, $enc ); ?>
	
	<p>Congratulations - hash created - <?php echo ( $hash ); ?> - id - <?php echo ( $id ); ?>. </p>
	
<?php }

echo ( $page_footer );
?>