<?php

include "config.php";

$REASON_SUCCESS=10;
$REASON_BAD_ATTEMPTS=20;
$REASON_EXPIRED=30;


$page_header = file_get_contents ( "page_header.html" );
$page_footer = file_get_contents ( "page_footer.html" );

$scrypt_rounds = 100000;


try {
	$meta_dbh = new PDO(
		'mysql:host=' . $db_server . ';port=' . $db_port . ';dbname=' . $db_meta_db,
		$db_meta_user,
		$db_meta_pass);
		
	$pass_dbh = new PDO(
		'mysql:host=' . $db_server . ';port=' . $db_port . ';dbname=' . $db_pass_db,
		$db_pass_user,
		$db_pass_pass);
}
catch ( PDOException $e ) {
	print "Error!: " . $e -> getMessage() . "<br/>";
	die();
}

if ( extension_loaded ( 'mcrypt' ) === FALSE) {
   die ( 'The Mcrypt module could not be loaded.' );
}

function create_password ( $id, $reference, $date, $username, $salt, $iv, $check, $enc ) {
	global $pass_dbh;
	global $meta_dbh;
	
	$pass_sql = 'INSERT INTO `passwords` (`password`) VALUES (?);';
	$meta_sql = 'INSERT INTO `metadata` (`id`, `reference`, `date_created`, `username`, `salt`, `iv`, `code_check`, `bad_attempts`, `password_id`) VALUES (?, ?, ?, ?, ?, ?, ?, 0, ?);';
	
	try {
		$sth = $pass_dbh -> prepare ( $pass_sql );
		$sth -> execute ( array ( $enc ) );
	}
	catch ( PDOException $e ) {
		print "Error!: " . $e->getMessage() . "<br/>";
		die();
	}
	
	$pass_id = $pass_dbh -> lastInsertId();
	
	try {
		$sth = $meta_dbh -> prepare ( $meta_sql );
		$sth -> execute ( array ( $id, $reference, $date, $username, $salt, $iv, $check, $pass_id ) );
	}
	catch ( PDOException $e ) {
		print "Error!: " . $e->getMessage() . "<br/>";
		die();
	}
}

function retrieve_password ( $id ) {
	global $pass_dbh;

	$sql = 'SELECT `password` FROM `passwords` WHERE id=?;';

	try {
		$sth = $pass_dbh -> prepare ( $sql );
		$sth -> execute ( array ( $id ) );
	}
	catch ( PDOException $e ) {
		print "Error!: " . $e -> getMessage() . "<br/>";
		die();
	}

	$row = $sth -> fetchAll ( PDO::FETCH_ASSOC );
    
	$count = count( $row );
	if ( $count == 1 ) {
		return $row[ 0 ][ 'password' ];
	}
	
	die ( 'Password database invalid.' );
}

function retrieve_metadata ( $id ) {
	global $meta_dbh;
		
	$sql = 'SELECT `reference`, `salt`, `iv`, `code_check`, `password_id`, `date_deleted`, `delete_reason` FROM `metadata` WHERE id=?;';
	
	try {
		$sth = $meta_dbh -> prepare ( $sql );
		$sth -> execute ( array ( $id ) );
	}
	catch ( PDOException $e ) {
		print "Error!: " . $e -> getMessage() . "<br/>";
		die();
	}

	$row = $sth -> fetchAll ( PDO::FETCH_ASSOC );
    
	$count = count( $row );
	if ( $count == 1 ) {
		return $row[ 0 ];
	}
	
	return $count;
}

function get_history_rows ( $user ) {
	global $meta_dbh;
		
	$sql = 'SELECT `reference`, `date_created`, `date_deleted`, `delete_reason`, `bad_attempts` FROM `metadata` WHERE username=?;';
	
	try {
		$sth = $meta_dbh -> prepare ( $sql );
		$sth -> execute ( array ( $user ) );
	}
	catch ( PDOException $e ) {
		print "Error!: " . $e -> getMessage() . "<br/>";
		die();
	}
	
	while ( $row = $sth -> fetch ( PDO::FETCH_ASSOC ) ) { 
	
	switch ( $row[ 'delete_reason' ] ) {
		case 10:
			$reason = "Success";
			break;
		case 20:
			$reason = "Too many bad attempts";
			break;
		case 30:
			$reason = "Expired before retrieval";
			break;
		default:
			$reason="";
			break;
	}
	?>
		<tr>
			<td>
				<?php echo ( $row[ 'reference' ] ); ?>
			</td>
			<td>
				<?php echo ( $row[ 'date_created' ] ); ?>
			</td>
			<td>
				<?php echo ( $row[ 'date_deleted' ] ); ?>
			</td>
			<td>
				<?php echo ( $reason ); ?>
			</td>
			<td>
				<?php echo ( $row[ 'bad_attempts' ] ); ?>
			</td>
		</tr>
	<?php }
	
}

function increment_bad_attempts ( $id ) {
	global $meta_dbh;
	global $REASON_BAD_ATTEMPTS;
	
	$sql = 'SELECT `bad_attempts`, `password_id` FROM `metadata` WHERE id=?;';
	
	try {
		$sth = $meta_dbh -> prepare ( $sql );
		$sth -> execute ( array ( $id ) );
	}
	catch ( PDOException $e ) {
		print "Error!: " . $e -> getMessage() . "<br/>";
		die();
	}

	$row = $sth -> fetchAll ( PDO::FETCH_ASSOC );

	$count = count( $row );
	if ( $count != 1 ) {
		die ( 'Metadata database invalid (wrong number of rows.)' );
	}
	
	$count = ( int ) ( $row[ 0 ][ 'bad_attempts' ] );
	$pass_id = $row[ 0 ][ 'password_id' ];
	
	if ( !( is_int ( $count ) || $count == 0 ) ) {
		die ( 'Metadata database invalid (not integers.).' );
	}
	
	$count++;

	$sql = 'UPDATE `metadata` SET `bad_attempts` = ? where `id` = ?';
	
	try {
		$sth = $meta_dbh -> prepare ( $sql );
		$sth -> execute ( array ( $count, $id ) );
	}
	catch ( PDOException $e ) {
		print "Error!: " . $e -> getMessage() . "<br/>";
		die();
	}
	
	if ( $count >= 10 ) {
		delete_password ( $pass_id, $REASON_BAD_ATTEMPTS );
	}
	
	return;
	
}

function delete_password ( $id, $reason ) {
	global $meta_dbh;
	global $pass_dbh;

	$pass_sql = 'DELETE FROM `passwords` WHERE id=?;';
	$meta_sql = 'UPDATE `metadata` SET `date_deleted` = ?, `delete_reason` = ? where `password_id` = ?';

	try {
		$sth = $pass_dbh -> prepare ( $pass_sql );
		$sth -> execute ( array ( $id ) );
	}
	catch ( PDOException $e ) {
		print "Error!: " . $e -> getMessage() . "<br/>";
		die();
	}

	try {
		$sth = $meta_dbh -> prepare ( $meta_sql );
		$sth -> execute ( array ( date( "Y-m-d H:i:s" ), $reason, $id ) );
	}
	catch ( PDOException $e ) {
		print "Error!: " . $e -> getMessage() . "<br/>";
		die();
	}

	return;
}

function encrypt ( $input, $key, $iv ) {
	$size = mcrypt_get_block_size( 'rijndael-256' , 'cbc' );
	$input = pkcs5_pad ( $input, $size );
	$td = mcrypt_module_open ( 'rijndael-256', '', 'cbc', '' );
	mcrypt_generic_init ( $td, $key, $iv );
	$data = mcrypt_generic ( $td, $input );
	mcrypt_generic_deinit ( $td );
	mcrypt_module_close ( $td );
	return $data;
}

function decrypt( $input, $key, $iv ) {
	$size = mcrypt_get_block_size ( 'rijndael-256', 'cbc' );
	$td = mcrypt_module_open ( 'rijndael-256', '', 'cbc', '' );
	mcrypt_generic_init ( $td, $key, $iv );
	$data = mdecrypt_generic ( $td, $input );
	mcrypt_generic_deinit ( $td );
	mcrypt_module_close ( $td );
	$data = pkcs5_unpad ( $data );
	return $data;
}

function pkcs5_pad ( $text, $blocksize ) {
	$pad = $blocksize - ( strlen ( $text ) % $blocksize);
	return $text . str_repeat ( chr ( $pad ), $pad );
}

function pkcs5_unpad ( $text ) {
	$pad = ord ( $text { strlen ( $text ) - 1 } );
	if ( $pad > strlen ( $text ) ) return false;
	if ( strspn ( $text, chr ( $pad ), strlen ( $text ) - $pad ) != $pad ) return false;
	return substr ( $text, 0, -1 * $pad );
}

?>