<?php require 'include.php'; 
$page_name = "Secure Password Distribution";
$page_header = preg_replace ( '/PAGE_NAME/', $page_name, $page_header );
echo ( $page_header );

if ( !( isset ( $_POST[ 'reference' ] ) ) || $_POST[ 'reference' ] == '' ) { ?>
	<h3>Welcome back <?php echo ( $_SERVER[ 'REMOTE_USER' ] ); ?></h3>
	<form method="post">
		<p>SDP Reference: <input type="text" name="reference" id="reference" /></p>
		<p>Password to store: <input type="password" name="passwd" id="passwd" /></p>
		<p><input type="submit" name="Create" value="Create" /></p>
	</form>
	<p>Previous passwords issued:</p>
	<table>
		<tr>
			<td><b>SDP Reference</b></td>
			<td><b>Date Created</b></td>
			<td><b>Date Deleted</b></td>
			<td><b>Reason Deleted</b></td>
			<td><b>Failed Attempts</b></td>
		</tr>
		<?php get_history_rows ( $_SERVER[ 'REMOTE_USER' ] ); ?>
	</table>
<?php }
else {
	// We're creating something

	// Random padding
	//$salt = mcrypt_create_iv ( 16, MCRYPT_RAND );
	$salt = \Sodium\randombytes_buf(\Sodium\CRYPTO_PWHASH_SALTBYTES);

	// Value sent to end user to collect password
	$hash = md5 ( mcrypt_create_iv ( 128, MCRYPT_RAND ) );

	// ID sent to end user
	$id = substr ( md5 ( mcrypt_create_iv ( 128, MCRYPT_RAND ) ), 4, 6 );
	
	//TODO: Check ID is valid against db

	// Metadata
	$reference = $_POST[ 'reference' ];
	$username = $_SERVER[ 'REMOTE_USER' ];
	$username = "test";

	// What we're actually storing
	$password = $_POST[ 'passwd' ];

	// AES initialisation vector	
	$iv = mcrypt_create_iv ( 32, MCRYPT_RAND );
	
	// AES KDF - This needs to be a more secure hash - maybe run 100000 cycles? or move to sCrypt?
	// $key = pack ( 'H*', hash ( 'sha256', $salt . $reference . $hash ) );
	$key = \Sodium\crypto_pwhash(
			32, //AES256 - 256/8 = 32
			$reference . $hash,
			$salt,
			\Sodium\CRYPTO_PWHASH_OPSLIMIT_MODERATE,
			\Sodium\CRYPTO_PWHASH_MEMLIMIT_MODERATE
		);

	// Get the Ciphertext
	$enc = encrypt ( $password, $key, $iv );
	
	// This needs to be a more secure hash - maybe run 100000 cycles? or move to sCrypt?
	$check = pack ( 'H*', hash ( 'sha256', $enc . $hash ) );
	
	// Add to database
	create_password ( $id, $reference, date( "Y-m-d H:i:s" ), $username, $salt, $iv, $check, $enc );

	// Output some stuff
	?>

		<p>Congratulations - hash created - <?php echo ( $hash ); ?> - id - <?php echo ( $id ); ?>. Key: <?php print_r ( unpack( 'H*', $key ) ); ?>, Salt: <?php print_r ( unpack( 'H*', $salt ) ); ?></p>
	
<?php }

echo ( $page_footer );
?>
