<?php require 'include.php'; 
$page_name = "Secure Password Distribution";
$page_header = preg_replace ( '/PAGE_NAME/', $page_name, $page_header );
echo ( $page_header );

if ( !( isset ( $_GET[ 'id' ] ) ) || $_GET[ 'id' ] == '' ) { ?>
	<form method="get">
		<p>ID: <input type="text" name="id" id="id" /></p>
		<p>Hash: <input type="text" name="hash" id="hash" /></p>
		<p><input type="submit" name="Create" value="Fetch My Password" /></p>
	</form>
<?php }
else {
	$id = ( $_GET[ 'id' ] );
	if ( !preg_match ( '/^[0-9a-fA-F]{6}$/', $id ) ) {
		die ( 'Not an id' );
	}
	$hash = ( $_GET[ 'hash' ] );
	if ( !preg_match ( '/^[0-9a-fA-F]{32}$/', $hash ) ) {
		die ( 'Not a hash' );
	}

	$id = strtolower ( $id );
	$hash = strtolower ( $hash );
	
	$details = retrieve_metadata ( $id );
	
	if ( is_int ( $details ) ) {
		die ( $details . ' records found.  This id is incorrect or not unique.' );
	}
	
	$reference = $details[ 'reference' ];
	$salt = $details[ 'salt' ];
	$iv = $details[ 'iv' ];
	$check = $details[ 'code_check' ];
	$pass_id = $details[ 'password_id' ];
	$date_deleted = $details[ 'date_deleted' ];
	$delete_reason = $details[ 'delete_reason' ];
		
	if ( $date_deleted != NULL || $delete_reason != NULL ) {
		die ( 'Password already deleted.' );
	}
	
	$password = retrieve_password ( $pass_id );
	
	if ( $check != pack ( 'H*', hash('sha256', $password . $hash) ) ) {
		increment_bad_attempts( $id );
		die ( 'Incorrect hash' );
	}
	print_r ( unpack ( "H*", $salt ) );	
	delete_password ( $pass_id, $REASON_SUCCESS );
	
	// $key = pack( 'H*', hash( 'sha256', $salt . $reference . $hash ) );
	$key = \Sodium\crypto_pwhash(
			32, //AES256 - 256/8 = 32
			$reference . $hash,
			$salt,
			\Sodium\CRYPTO_PWHASH_OPSLIMIT_MODERATE,
			\Sodium\CRYPTO_PWHASH_MEMLIMIT_MODERATE
		);

	$dec = decrypt ( $password, $key, $iv ); ?>
	
	<p>Congratulations - password decrypted - <?php echo ( $dec ); ?>. </p>
	
<?php }

echo ( $page_footer );
?>
